<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Student extends CI_Controller { 



    function __construct() {

        parent::__construct();

        		$this->load->database();                                //Load Databse Class

                $this->load->library('session');					    //Load library for session

                $this->load->model('student_model');

  

    }



     /*student dashboard code to redirect to student page if successfull login** */

     function dashboard() {

        if ($this->session->userdata('student_login') != 1) redirect(base_url(), 'refresh');

       	$page_data['page_name'] = 'dashboard';

        $page_data['page_title'] = get_phrase('student Dashboard');

        $this->load->view('backend/index', $page_data);

    }

	/******************* / student dashboard code to redirect to student page if successfull login** */



    function manage_profile($param1 = null, $param2 = null, $param3 = null){

        if ($this->session->userdata('student_login') != 1) redirect(base_url(), 'refresh');

        if ($param1 == 'update') {

    

    

            $data['name']   =   $this->input->post('name');

            $data['email']  =   $this->input->post('email');

    

            $this->db->where('student_id', $this->session->userdata('student_id'));

            $this->db->update('student', $data);

            move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/student_image/' . $this->session->userdata('student_id') . '.jpg');

            $this->session->set_flashdata('flash_message', get_phrase('Info Updated'));

            redirect(base_url() . 'student/manage_profile', 'refresh');

           

        }

    

        if ($param1 == 'change_password') {

            $data['new_password']           =   sha1($this->input->post('new_password'));

            $data['confirm_new_password']   =   sha1($this->input->post('confirm_new_password'));

    

            if ($data['new_password'] == $data['confirm_new_password']) {

               

               $this->db->where('student_id', $this->session->userdata('student_id'));

               $this->db->update('student', array('password' => $data['new_password']));

               $this->session->set_flashdata('flash_message', get_phrase('Password Changed'));

            }

    

            else{

                $this->session->set_flashdata('error_message', get_phrase('Type the same password'));

            }

            redirect(base_url() . 'student/manage_profile', 'refresh');

        }

    

            $page_data['page_name']     = 'manage_profile';

            $page_data['page_title']    = get_phrase('Manage Profile');

            $page_data['edit_profile']  = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->result_array();

            $this->load->view('backend/index', $page_data);

        }





        function subject (){



            $student_profile = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->row();

            $select_student_class_id = $student_profile->class_id;



            $page_data['page_name']     = 'subject';

            $page_data['page_title']    = get_phrase('Class Subjects');

            $page_data['select_subject']  = $this->db->get_where('subject', array('class_id' => $select_student_class_id))->result_array();

            $this->load->view('backend/index', $page_data);

        }



        function teacher (){





            $student_profile = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->row();

            $select_student_class_id = $student_profile->class_id;



            $return_teacher_id = $this->db->get_where('subject', array('class_id' => $select_student_class_id))->row()->teacher_id;





            $page_data['page_name']     = 'teacher';

            $page_data['page_title']    = get_phrase('Class Teachers');

            $page_data['select_teacher']  = $this->db->get_where('teacher', array('teacher_id' => $return_teacher_id))->result_array();

            $this->load->view('backend/index', $page_data);

        }



        function class_mate (){



            $student_profile = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->row();

            $page_data['select_student_class_id']  = $student_profile->class_id;

            $page_data['page_name']     = 'class_mate';

            $page_data['page_title']    = get_phrase('Class Mate');

            $this->load->view('backend/index', $page_data);

        }



        function class_routine(){



            $student_profile = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->row();

            $page_data['class_id']  = $student_profile->class_id;



            $page_data['page_name']     = 'class_routine';

            $page_data['page_title']    = get_phrase('Class Timetable');

            $this->load->view('backend/index', $page_data);





        }



        function invoice($param1 = null, $param2 = null, $param3 = null){



            if($param1 == 'make_payment'){



                $invoice_id = $this->input->post('invoice_id');

                $payment_email = $this->db->get_where('settings', array('type' => 'paypal_email'))->row();

                $select_invoice = $this->db->get_where('invoice', array('invoice_id' => $invoice_id))->row();



                // SENDING USER TO PAYPAL TERMINAL.

                $this->paypal->add_field('rm', 2);

                $this->paypal->add_field('no_note', 0);

                $this->paypal->add_field('item_name', $select_invoice->title);

                $this->paypal->add_field('amount', $select_invoice->due);

                $this->paypal->add_field('custom', $select_invoice->invoice_id);

                $this->paypal->add_field('business', $payment_email->description);

                $this->paypal->add_field('notify_url', base_url('invoice/paypal_ipn'));

                $this->paypal->add_field('cancel_return', base_url('invoice/paypal_cancel'));

                $this->paypal->add_field('return', site_url('invoice/paypal_success'));



                $this->paypal->submit_paypal_post();

                //submitting info to the paypal teminal

            }





            if($param1 == 'paypal_ipn'){

                if($this->paypal->validate_ipn() == true){

                        $ipn_response = '';

                        foreach ($_POST as $key => $value){

                            $value = urlencode(stripslashes($value));

                            $ipn_response .= "\n$key=$value";

                        }



                    $page_data['payment_details']   = $ipn_response;

                    $page_data['payment_timestamp'] = strtotime(date("m/d/Y"));

                    $page_data['payment_method']    = '1';

                    $page_data['status']            = 'paid';

                    $invoice_id                = $_POST['custom'];

                    $this->db->where('invoice_id', $invoice_id);

                    $this->db->update('invoice', $page_data);



                    $data2['method']       =   '1';

                    $data2['invoice_id']   =   $_POST['custom'];

                    $data2['timestamp']    =   strtotime(date("m/d/Y"));

                    $data2['payment_type'] =   'income';

                    $data2['title']        =   $this->db->get_where('invoice' , array('invoice_id' => $data2['invoice_id']))->row()->title;

                    $data2['description']  =   $this->db->get_where('invoice' , array('invoice_id' => $data2['invoice_id']))->row()->description;

                    $data2['student_id']   =   $this->db->get_where('invoice' , array('invoice_id' => $data2['invoice_id']))->row()->student_id;

                    $data2['amount']       =   $this->db->get_where('invoice' , array('invoice_id' => $data2['invoice_id']))->row()->amount;

                    $this->db->insert('payment' , $data2);



                }

            }



            if($param1 == 'paypal_cancel'){

                $this->session->set_flashdata('error_message', get_phrase('Payment Cancelled'));

                redirect(base_url() . 'student/invoice', 'refresh');

                }

    

            if($param1 == 'paypal_success'){

                $this->session->set_flashdata('flash_message', get_phrase('Payment Successful'));

                redirect(base_url() . 'student/invoice', 'refresh');

            }

           



            $student_profile = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->row();

            $student_profile = $student_profile->student_id;



            $page_data['invoices']     = $this->db->get_where('invoice', array('student_id' => $student_profile))->result_array();

            $page_data['page_name']     = 'invoice';

            $page_data['page_title']    = get_phrase('All Invoices');

            $this->load->view('backend/index', $page_data);

        }



        function payment_history(){



            $student_profile = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->row();

            $student_profile = $student_profile->student_id;



            $page_data['invoices']     = $this->db->get_where('invoice', array('student_id' => $student_profile))->result_array();

            $page_data['page_name']     = 'payment_history';

            $page_data['page_title']    = get_phrase('Student History');

            $this->load->view('backend/index', $page_data);





        }

		

		

		/***************** Here, in the school system, there are two types of computer based test: This is the second exam codes where this can be used for multple questions, true or false question and fillig the gap types of questions.  *******************/

	

	function online_exam($param1 = '', $param2 = '') {

        if ($this->session->userdata('student_login') != 1)

            redirect(site_url('login'), 'refresh');

        if ($param1 == '') {

            $page_data['data'] = 'active';

            $page_data['exams'] = $this->crud_model->available_exams($this->session->userdata('login_user_id'));

        }



        $page_data['page_name'] = 'online_exam';

        $page_data['page_title'] = get_phrase('online_exams');

        $this->load->view('backend/index', $page_data);

    }



    function online_exam_result($param1 = '', $param2 = '') {

        if ($this->session->userdata('student_login') != 1)

            redirect(site_url('login'), 'refresh');

        if ($param1 == '') {

            $page_data['data2'] = 'active';

            $page_data['exams'] = $this->crud_model->available_exams($this->session->userdata('login_user_id'));

        }



        $page_data['page_name'] = 'online_exam_result';

        $page_data['page_title'] = get_phrase('online_exam_results');

        $this->load->view('backend/index', $page_data);

    }



    function take_online_exam($online_exam_code) {

        if ($this->session->userdata('student_login') != 1)

            redirect(site_url('login'), 'refresh');

        $online_exam_id = $this->db->get_where('online_exam', array('code' => $online_exam_code))->row()->online_exam_id;

        $student_id = $this->session->userdata('login_user_id');

        // check if the student has already taken the exam

        $check = array('student_id' => $student_id, 'online_exam_id' => $online_exam_id);

        $taken = $this->db->where($check)->get('online_exam_result')->num_rows();



        $this->crud_model->change_online_exam_status_to_attended_for_student($online_exam_id);



        $status = $this->crud_model->check_availability_for_student($online_exam_id);



        if ($status == 'submitted') {

            $page_data['page_name']  = 'page_not_found';

        }

        else{

            $page_data['page_name']  = 'online_exam_take';

        }

        $page_data['page_title'] = get_phrase('online_exam');

        $page_data['online_exam_id'] = $online_exam_id;

        $page_data['exam_info'] = $this->db->get_where('online_exam', array('online_exam_id' => $online_exam_id));

        $this->load->view('backend/index', $page_data);

    }



//************* the function below helps to submit the exam successfully by the students. ****************************************/

    function submit_online_exam($online_exam_id = ""){



        $answer_script = array();

        $question_bank = $this->db->get_where('question_bank', array('online_exam_id' => $online_exam_id))->result_array();



        foreach ($question_bank as $question) {



          $correct_answers  = $this->crud_model->get_correct_answer($question['question_bank_id']);

          $container_2 = array();

          if (isset($_POST[$question['question_bank_id']])) {



              foreach ($this->input->post($question['question_bank_id']) as $row) {

                  $submitted_answer = "";

                  if ($question['type'] == 'true_false') {

                      $submitted_answer = $row;

                  }

                  elseif($question['type'] == 'fill_in_the_blanks'){

                    $suitable_words = array();

                    $suitable_words_array = explode(',', $row);

                    foreach ($suitable_words_array as $key) {

                      array_push($suitable_words, strtolower($key));

                    }

                    $submitted_answer = json_encode(array_map('trim',$suitable_words));

                  }

                  else{

                      array_push($container_2, strtolower($row));

                      $submitted_answer = json_encode($container_2);

                  }

                  $container = array(

                      "question_bank_id" => $question['question_bank_id'],

                      "submitted_answer" => $submitted_answer,

                      "correct_answers"  => $correct_answers

                  );

              }

          }

          else {

              $container = array(

                  "question_bank_id" => $question['question_bank_id'],

                  "submitted_answer" => "",

                  "correct_answers"  => $correct_answers

              );

          }



          array_push($answer_script, $container);

        }

        $this->crud_model->submit_online_exam($online_exam_id, json_encode($answer_script));

        redirect(site_url('student/online_exam'), 'refresh');

    }

	/***************** /  Here, in the school system, there are two types of computer based test: This is the second exam codes where this can be used for multple questions, true or false question and fillig the gap types of questions.  *******************/





        function studentRequestBook($param1 = null, $param2 = null, $param3 = null){



            if($param1 == 'create'){

                $this->student_model->create_student_request_book();

                $this->session->set_flashdata('flash_message', get_phrase('Data sent successful'));

                redirect(base_url() . 'student/studentRequestBook', 'refresh');

            }





            $page_data['page_name']     = 'studentRequestBook';

            $page_data['page_title']    = get_phrase('Request Book');

            $this->load->view('backend/index', $page_data);



        }

		

		 /*********** the function loads student mid term mark ********************/

		function student_marksheet_mid($student_id = '') {

			if ($this->session->userdata('student_login') != 1)

			redirect('login', 'refresh');

			$class_id     = $this->db->get_where('student' , array('student_id' => $student_id))->row()->class_id;

			$student_name = $this->db->get_where('student' , array('student_id' => $student_id))->row()->name;

			$class_name   = $this->db->get_where('class' , array('class_id' => $class_id))->row()->name;

			$page_data['page_name']  =   'student_marksheet_mid';

			$page_data['page_title'] =   get_phrase('marksheet_for') . ' ' . $student_name . ' (' . get_phrase('class') . ' ' . $class_name . ')';

			$page_data['student_id'] =   $student_id;

			$page_data['class_id']   =   $class_id;

			$this->load->view('backend/index', $page_data);

		}

	  /*********** the function loads student mid term mark ends here

		

		

		 /*********** the function loads student mark ********************/

		function student_marksheet($student_id = '') {

			if ($this->session->userdata('student_login') != 1)

			redirect('login', 'refresh');

			$class_id     = $this->db->get_where('student' , array('student_id' => $student_id))->row()->class_id;

			$student_name = $this->db->get_where('student' , array('student_id' => $student_id))->row()->name;

			$class_name   = $this->db->get_where('class' , array('class_id' => $class_id))->row()->name;

			$page_data['page_name']  =   'student_marksheet';

			$page_data['page_title'] =   get_phrase('marksheet_for') . ' ' . $student_name . ' (' . get_phrase('class') . ' ' . $class_name . ')';

			$page_data['student_id'] =   $student_id;

			$page_data['class_id']   =   $class_id;

			$this->load->view('backend/index', $page_data);

		}

	  /*********** the function loads student mark ends here ********************/

	

	/********************* Print and view mid term report sheet **********************/

		function printResultSheet_mid($student_id , $exam_id)

		{

		 if ($this->session->userdata('student_login') != 1)

		 redirect(base_url(), 'refresh');

		 

		 

		 $class_id     = $this->db->get_where('student' , array('student_id' => $student_id))->row()->class_id;

		 $class_name   = $this->db->get_where('class' , array('class_id' => $class_id))->row()->name;

		

		$page_data['student_id'] =   $student_id;

		$page_data['class_id']   =   $class_id;

		$page_data['exam_id']    =   $exam_id;

		$page_data['page_name']  = 'printResultSheet_mid';

		$page_data['page_title'] = get_phrase('print_result_sheet');

		$this->load->view('backend/index', $page_data);

		}

		/********************* Print and view mid term sheet ends here **********************/





	

	

	/********************* Print and view tabulation sheet **********************/

	function printResultSheet($student_id , $exam_id)
	{
		if ($this->session->userdata('student_login') != 1)
		redirect(base_url(), 'refresh');
		$class_id     = $this->db->get_where('student' , array('student_id' => $student_id))->row()->class_id;
		$class_name   = $this->db->get_where('class' , array('class_id' => $class_id))->row()->name;
		$page_data['student_id'] =   $student_id;
		$page_data['class_id']   =   $class_id;
		$page_data['exam_id']    =   $exam_id;
		$page_data['page_name']  = 'printResultSheet';
		$page_data['page_title'] = get_phrase('print_result_sheet');
		$this->load->view('backend/index', $page_data);
	}
		/********************* Print and view tabulation sheet ends here **********************/
}