<?php if (!defined('BASEPATH')) exit('No direct script access allowed');





class Admin extends CI_Controller
{



    function __construct()
    {

        parent::__construct();

        $this->load->database();                                //Load Databse Class

        $this->load->library('session');                        //Load library for session

        $this->load->model('vacancy_model');                    // Load vacancy Model Here

        $this->load->model('application_model');                // Load Apllication Model Here

        $this->load->model('leave_model');                      // Load Apllication Model Here

        $this->load->model('award_model');                      // Load Apllication Model Here

        $this->load->model('academic_model');                   // Load Apllication Model Here

        $this->load->model('student_model');                    // Load Apllication Model Here

        $this->load->model('exam_question_model');              // Load Apllication Model Here

        $this->load->model('student_payment_model');            // Load Apllication Model Here

        $this->load->model('event_model');                      // Load Apllication Model Here

        $this->load->model('language_model');                      // Load Apllication Model Here

        $this->load->model('admin_model');                      // Load Apllication Model Here

        $this->load->model('Barcode_model');                    // Loading the Barcode Model
        $this->load->model('Crud_model');                    // Loading the Barcode Model

        $this->load->library('phpqrcode/qrlib');                // Loading Qr From the Library

        $this->load->model('website_model');
    }



    /**default functin, redirects to login page if no admin logged in yet***/

    public function index()

    {

        if ($this->session->userdata('admin_login') != 1) redirect(base_url() . 'login', 'refresh');

        if ($this->session->userdata('admin_login') == 1) redirect(base_url() . 'admin/dashboard', 'refresh');
    }

    /************* / default functin, redirects to login page if no admin logged in yet***/



    /*Admin dashboard code to redirect to admin page if successfull login** */

    function dashboard()
    {

        if ($this->session->userdata('admin_login') != 1) redirect(base_url(), 'refresh');

        $page_data['page_name'] = 'dashboard';

        $page_data['page_title'] = get_phrase('admin_dashboard');

        $this->load->view('backend/index', $page_data);
    }

    /******************* / Admin dashboard code to redirect to admin page if successfull login** */





    function manage_profile($param1 = null, $param2 = null, $param3 = null)
    {

        if ($this->session->userdata('admin_login') != 1) redirect(base_url(), 'refresh');

        if ($param1 == 'update') {





            $data['name']   =   $this->input->post('name');

            $data['email']  =   $this->input->post('email');



            $this->db->where('admin_id', $this->session->userdata('admin_id'));

            $this->db->update('admin', $data);

            move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/admin_image/' . $this->session->userdata('admin_id') . '.jpg');

            $this->session->set_flashdata('flash_message', get_phrase('Info Updated'));

            redirect(base_url() . 'admin/manage_profile', 'refresh');
        }



        if ($param1 == 'change_password') {

            $data['new_password']           =   sha1($this->input->post('new_password'));

            $data['confirm_new_password']   =   sha1($this->input->post('confirm_new_password'));



            if ($data['new_password'] == $data['confirm_new_password']) {



                $this->db->where('admin_id', $this->session->userdata('admin_id'));

                $this->db->update('admin', array('password' => $data['new_password']));

                $this->session->set_flashdata('flash_message', get_phrase('Password Changed'));
            } else {

                $this->session->set_flashdata('error_message', get_phrase('Type the same password'));
            }

            redirect(base_url() . 'admin/manage_profile', 'refresh');
        }



        $page_data['page_name']     = 'manage_profile';

        $page_data['page_title']    = get_phrase('Manage Profile');

        $page_data['edit_profile']  = $this->db->get_where('admin', array('admin_id' => $this->session->userdata('admin_id')))->result_array();

        $this->load->view('backend/index', $page_data);
    }





    function enquiry_category($param1 = null, $param2 = null, $param3 = null)
    {

        if ($param1 == 'insert') {



            $this->crud_model->enquiry_category();



            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/enquiry_category', 'refresh');
        }



        if ($param1 == 'update') {



            $this->crud_model->update_category($param2);





            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/enquiry_category', 'refresh');
        }



        if ($param1 == 'delete') {



            $this->crud_model->delete_category($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/enquiry_category', 'refresh');
        }



        $page_data['page_name']     = 'enquiry_category';

        $page_data['page_title']    = get_phrase('Manage Category');

        $page_data['enquiry_category']  = $this->db->get('enquiry_category')->result_array();

        $this->load->view('backend/index', $page_data);
    }





    function list_enquiry($param1 = null, $param2 = null, $param3 = null)
    {





        if ($param1 == 'delete') {

            $this->crud_model->delete_enquiry($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/list_enquiry', 'refresh');
        }



        $page_data['page_name']     = 'list_enquiry';

        $page_data['page_title']    = get_phrase('All Enquiries');

        $page_data['select_enquiry']  = $this->db->get('enquiry')->result_array();

        $this->load->view('backend/index', $page_data);
    }







    function club($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {

            $this->crud_model->insert_club();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/club', 'refresh');
        }



        if ($param1 == 'update') {

            $this->crud_model->update_club($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/club', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->crud_model->delete_club($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/club', 'refresh');
        }





        $page_data['page_name']     = 'club';

        $page_data['page_title']    = get_phrase('Manage Club');

        $page_data['select_club']  = $this->db->get('club')->result_array();

        $this->load->view('backend/index', $page_data);
    }





    function circular($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {



            $this->crud_model->insert_circular();

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully saved'));

            redirect(base_url() . 'admin/circular', 'refresh');
        }





        if ($param1 == 'update') {



            $this->crud_model->update_circular($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully updated'));

            redirect(base_url() . 'admin/circular', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->crud_model->delete_circular($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully deleted'));

            redirect(base_url() . 'admin/circular', 'refresh');
        }



        $page_data['page_name']         = 'circular';

        $page_data['page_title']        = get_phrase('Manage Circular');

        $page_data['select_circular']   = $this->db->get('circular')->result_array();

        $this->load->view('backend/index', $page_data);
    }





    function parent($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {



            $this->crud_model->insert_parent();

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully saved'));

            redirect(base_url() . 'admin/parent', 'refresh');
        }





        if ($param1 == 'update') {



            $this->crud_model->update_parent($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully updated'));

            redirect(base_url() . 'admin/parent', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->crud_model->delete_parent($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully deleted'));

            redirect(base_url() . 'admin/parent', 'refresh');
        }



        $page_data['page_name']         = 'parent';

        $page_data['page_title']        = get_phrase('Manage Parent');

        $page_data['select_parent']   = $this->db->get('parent')->result_array();

        $this->load->view('backend/index', $page_data);
    }





    function librarian($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {



            $this->crud_model->insert_librarian();



            $this->session->set_flashdata('flash_message', get_phrase('Data successfully saved'));

            redirect(base_url() . 'admin/librarian', 'refresh');
        }





        if ($param1 == 'update') {



            $this->crud_model->update_librarian($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully updated'));

            redirect(base_url() . 'admin/librarian', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->crud_model->delete_librarian($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully deleted'));

            redirect(base_url() . 'admin/librarian', 'refresh');
        }



        $page_data['page_name']         = 'librarian';

        $page_data['page_title']        = get_phrase('Manage Librarian');

        $page_data['select_librarian']   = $this->db->get('librarian')->result_array();

        $this->load->view('backend/index', $page_data);
    }







    function accountant($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {



            $this->crud_model->insert_accountant();



            $this->session->set_flashdata('flash_message', get_phrase('Data successfully saved'));

            redirect(base_url() . 'admin/accountant', 'refresh');
        }





        if ($param1 == 'update') {



            $this->crud_model->update_accountant($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully updated'));

            redirect(base_url() . 'admin/accountant', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->crud_model->delete_accountant($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully deleted'));

            redirect(base_url() . 'admin/accountant', 'refresh');
        }



        $page_data['page_name']         = 'accountant';

        $page_data['page_title']        = get_phrase('Manage Accountant');

        $page_data['select_accountant']   = $this->db->get('accountant')->result_array();

        $this->load->view('backend/index', $page_data);
    }









    function hostel($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {



            $this->crud_model->insert_hostel();



            $this->session->set_flashdata('flash_message', get_phrase('Data successfully saved'));

            redirect(base_url() . 'admin/hostel', 'refresh');
        }





        if ($param1 == 'update') {



            $this->crud_model->update_hostel($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully updated'));

            redirect(base_url() . 'admin/hostel', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->crud_model->delete_hostel($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully deleted'));

            redirect(base_url() . 'admin/hostel', 'refresh');
        }



        $page_data['page_name']         = 'hostel';

        $page_data['page_title']        = get_phrase('Manage Hostel');

        $page_data['select_hostel']     = $this->db->get('hostel')->result_array();

        $this->load->view('backend/index', $page_data);
    }











    function hrm($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {



            $this->crud_model->insert_hrm();



            $this->session->set_flashdata('flash_message', get_phrase('Data successfully saved'));

            redirect(base_url() . 'admin/hrm', 'refresh');
        }





        if ($param1 == 'update') {



            $this->crud_model->update_hrm($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully updated'));

            redirect(base_url() . 'admin/hrm', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->crud_model->delete_hrm($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully deleted'));

            redirect(base_url() . 'admin/hrm', 'refresh');
        }



        $page_data['page_name']         = 'hrm';

        $page_data['page_title']        = get_phrase('Manage HRM');

        $page_data['select_hrm']        = $this->db->get('hrm')->result_array();

        $this->load->view('backend/index', $page_data);
    }









    function alumni($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {



            $this->alumni_model->insert_alumni();



            $this->session->set_flashdata('flash_message', get_phrase('Data successfully saved'));

            redirect(base_url() . 'admin/alumni', 'refresh');
        }





        if ($param1 == 'update') {



            $this->alumni_model->update_alumni($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully updated'));

            redirect(base_url() . 'admin/alumni', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->alumni_model->delete_alumni($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data successfully deleted'));

            redirect(base_url() . 'admin/alumni', 'refresh');
        }



        $page_data['page_name']         = 'alumni';

        $page_data['page_title']        = get_phrase('Manage Alumni');

        $page_data['select_alumni']        = $this->db->get('alumni')->result_array();

        $this->load->view('backend/index', $page_data);
    }





    function teacher($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {

            $this->teacher_model->insetTeacherFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/teacher', 'refresh');
        }



        if ($param1 == 'update') {

            $this->teacher_model->updateTeacherFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/teacher', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->teacher_model->deleteTeacherFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/teacher', 'refresh');
        }



        $page_data['page_name']     = 'teacher';

        $page_data['page_title']    = get_phrase('Manage Teacher');

        $page_data['select_teacher']  = $this->db->get('teacher')->result_array();

        $this->load->view('backend/index', $page_data);
    }



    function get_designation($department_id = null)
    {



        $designation = $this->db->get_where('designation', array('department_id' => $department_id))->result_array();

        foreach ($designation as $key => $row)

            echo '<option value="' . $row['designation_id'] . '">' . $row['name'] . '</option>';
    }



    /***********  The function manages vacancy   ***********************/

    function vacancy($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {

            $this->vacancy_model->insetVacancyFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/vacancy', 'refresh');
        }



        if ($param1 == 'update') {

            $this->vacancy_model->updateVacancyFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/vacancy', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->vacancy_model->deleteVacancyFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/vacancy', 'refresh');
        }



        $page_data['page_name']     = 'vacancy';

        $page_data['page_title']    = get_phrase('Manage Vacancy');

        $page_data['select_vacancy']  = $this->db->get('vacancy')->result_array();

        $this->load->view('backend/index', $page_data);
    }





    /***********  The function manages job applicant   ***********************/

    function application($param1 = 'applied', $param2 = null, $param3 = null)
    {



        if ($param1 == 'insert') {

            $this->application_model->insertApplicantFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/application', 'refresh');
        }



        if ($param1 == 'update') {

            $this->application_model->updateApplicantFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/application', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->application_model->deleteApplicantFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/application', 'refresh');
        }



        if ($param1 != 'applied' && $param1 != 'on_review' && $param1 != 'interviewed' && $param1 != 'offered' && $param1 != 'hired' && $param1 != 'declined')

            $param1 = 'applied';







        $page_data['status']        = $param1;

        $page_data['page_name']     = 'application';

        $page_data['page_title']    = get_phrase('Job Applicant');

        $this->load->view('backend/index', $page_data);
    }





    /***********  The function manages Leave  ***********************/

    function leave($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'update') {

            $this->leave_model->updateLeaveFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/leave', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->leave_model->deleteLeaveFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/leave', 'refresh');
        }



        $page_data['page_name']     = 'leave';

        $page_data['page_title']    = get_phrase('Manage Leave');

        $this->load->view('backend/index', $page_data);
    }





    /***********  The function manages Awards  ***********************/

    function award($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->award_model->createAwardFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/award', 'refresh');
        }



        if ($param1 == 'update') {

            $this->award_model->updateAwardFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/award', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->award_model->deleteAwardFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/award', 'refresh');
        }



        $page_data['page_name']     = 'award';

        $page_data['page_title']    = get_phrase('Manage Award');

        $this->load->view('backend/index', $page_data);
    }



    function payroll()
    {



        $page_data['page_name']     = 'payroll_add';

        $page_data['page_title']    = get_phrase('Create Payslip');

        $this->load->view('backend/index', $page_data);
    }



    function get_employees($department_id = null)

    {

        $employees = $this->db->get_where('teacher', array('department_id' => $department_id))->result_array();

        foreach ($employees as $key => $employees)

            echo '<option value="' . $employees['teacher_id'] . '">' . $employees['name'] . '</option>';
    }



    function payroll_selector()

    {

        $department_id  = $this->input->post('department_id');

        $employee_id    = $this->input->post('employee_id');

        $month          = $this->input->post('month');

        $year           = $this->input->post('year');



        redirect(base_url() . 'admin/payroll_view/' . $department_id . '/' . $employee_id . '/' . $month . '/' . $year, 'refresh');
    }



    function payroll_view($department_id = null, $employee_id = null, $month = null, $year = null)

    {

        $page_data['department_id'] = $department_id;

        $page_data['employee_id']   = $employee_id;

        $page_data['month']         = $month;

        $page_data['year']          = $year;

        $page_data['page_name']     = 'payroll_add_view';

        $page_data['page_title']    = get_phrase('Create Payslip');

        $this->load->view('backend/index', $page_data);
    }





    function create_payroll()
    {



        $this->payroll_model->insertPayrollFunction();

        $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

        redirect(base_url() . 'admin/payroll_list/filter2/' . $this->input->post('month') . '/' . $this->input->post('year'), 'refresh');
    }





    /***********  The function manages Payroll List  ***********************/

    function payroll_list($param1 = null, $param2 = null, $param3 = null, $param4 = null)
    {



        if ($param1 == 'mark_paid') {



            $data['status'] =  1;

            $this->db->update('payroll', $data, array('payroll_id' => $param2));



            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/payroll_list/filter2/' . $param3 . '/' . $param4, 'refresh');
        }



        if ($param1 == 'filter') {

            $page_data['month'] = $this->input->post('month');

            $page_data['year'] = $this->input->post('year');
        } else {

            $page_data['month'] = date('n');

            $page_data['year'] = date('Y');
        }



        if ($param1 == 'filter2') {



            $page_data['month'] = $param2;

            $page_data['year'] = $param3;
        }





        $page_data['page_name']     = 'payroll_list';

        $page_data['page_title']    = get_phrase('List Payroll');

        $this->load->view('backend/index', $page_data);
    }



    /***********  The function manages Class Information  ***********************/

    function classes($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->class_model->createClassFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/classes', 'refresh');
        }



        if ($param1 == 'update') {

            $this->class_model->updateClassFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/classes', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->class_model->deleteClassFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/classes', 'refresh');
        }



        $page_data['page_name']     = 'class';

        $page_data['page_title']    = get_phrase('Manage Class');

        $this->load->view('backend/index', $page_data);
    }





    /***********  The function manages Section  ***********************/

    function section($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->section_model->createSectionFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/section', 'refresh');
        }



        if ($param1 == 'update') {

            $this->section_model->updateSectionFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/section', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->section_model->deleteSectionFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/section', 'refresh');
        }



        $page_data['page_name']     = 'section';

        $page_data['page_title']    = get_phrase('Manage Section');

        $this->load->view('backend/index', $page_data);
    }



    function sections($class_id = null)
    {



        if ($class_id == '')

            $class_id = $this->db->get('class')->first_row()->class_id;



        $page_data['page_name']     = 'section';

        $page_data['class_id']      = $class_id;

        $page_data['page_title']    = get_phrase('Manage Section');

        $this->load->view('backend/index', $page_data);
    }





    /***********  The function manages school timetable  ***********************/

    function class_routine($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->class_routine_model->createTimetableFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/listStudentTimetable', 'refresh');
        }



        if ($param1 == 'update') {



            $this->class_routine_model->updateTimetableFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/listStudentTimetable', 'refresh');
        }



        if ($param1 == 'delete') {



            $this->db->where('class_routine_id', $param2);

            $this->db->delete('class_routine');

            //$this->class_routine_model->deleteTimetableFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/listStudentTimetable', 'refresh');
        }
    }



    function listStudentTimetable()
    {



        $page_data['page_name']     = 'listStudentTimetable';

        $page_data['page_title']    = get_phrase('School Timetable');

        $this->load->view('backend/index', $page_data);
    }



    function class_routine_add()
    {



        $page_data['page_name']     = 'class_routine_add';

        $page_data['page_title']    = get_phrase('School Timetable');

        $this->load->view('backend/index', $page_data);
    }



    function get_class_section_subject($class_id)
    {

        $page_data['class_id']  =   $class_id;

        $this->load->view('backend/admin/class_routine_section_subject_selector', $page_data);
    }



    function studentTimetableLoad($class_id)
    {



        $page_data['class_id']  =   $class_id;

        $this->load->view('backend/admin/studentTimetableLoad', $page_data);
    }



    function class_routine_print_view($class_id, $section_id)
    {



        $page_data['class_id']      =   $class_id;

        $page_data['section_id']    =   $section_id;

        $this->load->view('backend/admin/class_routine_print_view', $page_data);
    }





    function section_subject_edit($class_id, $class_routine_id)
    {



        $page_data['class_id']          =   $class_id;

        $page_data['class_routine_id']  =   $class_routine_id;

        $this->load->view('backend/admin/class_routine_section_subject_edit', $page_data);
    }





    /***********  The function manages school dormitory  ***********************/

    function dormitory($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->dormitory_model->createDormitoryFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/dormitory', 'refresh');
        }



        if ($param1 == 'update') {

            $this->dormitory_model->updateDormitoryFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/dormitory', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->dormitory_model->deleteDormitoryFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/dormitory', 'refresh');
        }



        $page_data['page_name']     = 'dormitory';

        $page_data['page_title']    = get_phrase('Manage Dormitory');

        $this->load->view('backend/index', $page_data);
    }





    /***********  The function manages hostel room  ***********************/

    function hostel_room($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->dormitory_model->createHostelRoomFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/hostel_room', 'refresh');
        }



        if ($param1 == 'update') {

            $this->dormitory_model->updateHostelRoomFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/hostel_room', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->dormitory_model->deleteHostelRoomFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/hostel_room', 'refresh');
        }



        $page_data['page_name']     = 'hostel_room';

        $page_data['page_title']    = get_phrase('Hostel Room');

        $this->load->view('backend/index', $page_data);
    }





    /***********  The function manages hostel category  ***********************/

    function hostel_category($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->dormitory_model->createHostelCategoryFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/hostel_category', 'refresh');
        }



        if ($param1 == 'update') {

            $this->dormitory_model->updateHostelCategoryFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/hostel_category', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->dormitory_model->deleteHostelCategoryFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/hostel_category', 'refresh');
        }



        $page_data['page_name']     = 'hostel_category';

        $page_data['page_title']    = get_phrase('Hostel Category');

        $this->load->view('backend/index', $page_data);
    }







    /***********  The function manages academic syllabus ***********************/

    function academic_syllabus($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->academic_model->createAcademicSyllabus();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/academic_syllabus', 'refresh');
        }



        if ($param1 == 'update') {

            $this->academic_model->updateAcademicSyllabus($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/academic_syllabus', 'refresh');
        }





        if ($param1 == 'delete') {

            $this->academic_model->deleteAcademicSyllabus($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/academic_syllabus', 'refresh');
        }



        $page_data['page_name']     = 'academic_syllabus';

        $page_data['page_title']    = get_phrase('Academic Syllabus');

        $this->load->view('backend/index', $page_data);
    }



    function get_class_subject($class_id)
    {

        $subjects = $this->db->get_where('subject', array('class_id' => $class_id))->result_array();

        foreach ($subjects as $key => $subject) {

            echo '<option value="' . $subject['subject_id'] . '">' . $subject['name'] . '</option>';
        }
    }



    function get_class_section($class_id)
    {

        $sections = $this->db->get_where('section', array('class_id' => $class_id))->result_array();

        foreach ($sections as $key => $section) {

            echo '<option value="' . $section['section_id'] . '">' . $section['name'] . '</option>';
        }
    }





    function download_academic_syllabus($academic_syllabus_code)
    {

        $get_file_name = $this->db->get_where('academic_syllabus', array('academic_syllabus_code' => $academic_syllabus_code))->row()->file_name;

        // Loading download from helper.

        $this->load->helper('download');

        $get_download_content = file_get_contents('uploads/syllabus' . $get_file_name);

        $name = $file_name;

        force_download($name, $get_download_content);
    }



    function get_academic_syllabus($class_id = null)
    {



        if ($class_id == '')

            $class_id = $this->db->get('class')->first_row()->class_id;



        $page_data['page_name']     = 'academic_syllabus';

        $page_data['class_id']      = $class_id;

        $page_data['page_title']    = get_phrase('Academic Syllabus');

        $this->load->view('backend/index', $page_data);
    }



    /***********  The function below add, update and delete student from students' table ***********************/

    function new_student($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->student_model->createNewStudent();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/student_information', 'refresh');
        }



        if ($param1 == 'update') {

            $this->student_model->updateNewStudent($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/student_information', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->student_model->deleteNewStudent($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/student_information', 'refresh');
        }



        $page_data['page_name']     = 'new_student';

        $page_data['page_title']    = get_phrase('Manage Student');

        $this->load->view('backend/index', $page_data);
    }

    function admit_bulk_student()
    {

        $page_data['page_name']     = 'admit_bulk_student';

        $page_data['page_title']    = get_phrase('Admit Bulk Student');

        $this->load->view('backend/index', $page_data);
    }




    function student_information()
    {



        $page_data['page_name']     = 'student_information';

        $page_data['page_title']    = get_phrase('List Student');

        $this->load->view('backend/index', $page_data);
    }





    /**************************  search student function with ajax starts here   ***********************************/

    function getStudentClasswise($class_id)
    {



        $page_data['class_id'] = $class_id;

        $this->load->view('backend/admin/showStudentClasswise', $page_data);
    }

    /**************************  search student function with ajax ends here   ***********************************/





    function edit_student($student_id)
    {



        $page_data['student_id']      = $student_id;

        $page_data['page_name']     = 'edit_student';

        $page_data['page_title']    = get_phrase('Edit Student');

        $this->load->view('backend/index', $page_data);
    }





    function resetStudentPassword($student_id)
    {

        $password['password']               =   sha1($this->input->post('new_password'));

        $confirm_password['confirm_new_password']   =   sha1($this->input->post('confirm_new_password'));

        if ($password['password'] == $confirm_password['confirm_new_password']) {

            $this->db->where('student_id', $student_id);

            $this->db->update('student', $password);

            $this->session->set_flashdata('flash_message', get_phrase('Password Changed'));
        } else {

            $this->session->set_flashdata('error_message', get_phrase('Type the same password'));
        }

        redirect(base_url() . 'admin/student_information', 'refresh');
    }



    function manage_attendance($date = null, $month = null, $year = null, $class_id = null, $section_id = null)
    {

        $active_sms_gateway = $this->db->get_where('sms_settings', array('type' => 'active_sms_gateway'))->row()->info;



        if ($_POST) {



            // Loop all the students of $class_id

            $students = $this->db->get_where('student', array('class_id' => $class_id))->result_array();

            foreach ($students as $key => $student) {

                $attendance_status = $this->input->post('status_' . $student['student_id']);

                $attendance_session = $this->db->get_where('settings', array('type' => 'session'))->row()->description;

                $full_date = $year . "-" . $month . "-" . $date;

                $this->db->where('student_id', $student['student_id']);

                $this->db->where('date', $full_date);



                $this->db->update('attendance', array('status' => $attendance_status, 'session' => $attendance_session));



                if ($attendance_status == 2) {

                    if ($active_sms_gateway != '' || $active_sms_gateway != 'disabled') {

                        $student_name   = $this->db->get_where('student', array('student_id' => $student['student_id']))->row()->name;

                        $parent_id      = $this->db->get_where('student', array('student_id' => $student['student_id']))->row()->parent_id;

                        $message        = 'Your child' . ' ' . $student_name . 'is absent today.';

                        if ($parent_id != null && $parent_id != 0) {

                            $recieverPhoneNumber = $this->db->get_where('parent', array('parent_id' => $parent_id))->row()->phone;

                            if ($recieverPhoneNumber != '' || $recieverPhoneNumber != null) {

                                $this->sms_model->send_sms($message, $recieverPhoneNumber);
                            } else {

                                $this->session->set_flashdata('error_message', get_phrase('Parent Phone Not Found'));
                            }
                        } else {

                            $this->session->set_flashdata('error_message', get_phrase('SMS Gateway Not Found'));
                        }
                    }
                }
            }



            $this->session->set_flashdata('flash_message', get_phrase('Updated Successfully'));

            redirect(base_url() . 'admin/manage_attendance/' . $date . '/' . $month . '/' . $year . '/' . $class_id . '/' . $section_id, 'refresh');
        }



        $page_data['date'] = $date;

        $page_data['month'] = $month;

        $page_data['year'] = $year;

        $page_data['class_id'] = $class_id;

        $page_data['section_id'] = $section_id;

        $page_data['page_name'] = 'manage_attendance';

        $page_data['page_title'] = get_phrase('Manage Attendance');

        $this->load->view('backend/index', $page_data);
    }



    function attendance_selector()
    {

        $date = $this->input->post('timestamp');

        $date = date_create($date);

        $date = date_format($date, "d/m/Y");

        redirect(base_url() . 'admin/manage_attendance/' . $date . '/' . $this->input->post('class_id') . '/' . $this->input->post('section_id'), 'refresh');
    }





    function attendance_report($class_id = NULL, $section_id = NULL, $month = NULL, $year = NULL)
    {



        $active_sms_gateway = $this->db->get_where('sms_settings', array('type' => 'active_sms_gateway'))->row()->info;





        if ($_POST) {

            redirect(base_url() . 'admin/attendance_report/' . $class_id . '/' . $section_id . '/' . $month . '/' . $year, 'refresh');
        }



        $classes = $this->db->get('class')->result_array();

        foreach ($classes as $key => $class) {

            if (isset($class_id) && $class_id == $class['class_id'])

                $class_name = $class['name'];
        }



        $sections = $this->db->get('section')->result_array();

        foreach ($sections as $key => $section) {

            if (isset($section_id) && $section_id == $section['section_id'])

                $section_name = $section['name'];
        }



        $page_data['month'] = $month;

        $page_data['year'] = $year;

        $page_data['class_id'] = $class_id;

        $page_data['section_id'] = $section_id;

        $page_data['page_name'] = 'attendance_report';

        $page_data['page_title'] = "Attendance Report:" . $class_name . " : Section " . $section_name;

        $this->load->view('backend/index', $page_data);
    }





    /******************** Load attendance with ajax code starts from here **********************/

    function loadAttendanceReport($class_id, $section_id, $month, $year)

    {

        $page_data['class_id']         = $class_id;                    // get all class_id

        $page_data['section_id']     = $section_id;                    // get all section_id

        $page_data['month']         = $month;                        // get all month

        $page_data['year']             = $year;                        // get all class year



        $this->load->view('backend/admin/loadAttendanceReport', $page_data);
    }

    /******************** Load attendance with ajax code ends from here **********************/





    /******************** print attendance report **********************/

    function printAttendanceReport($class_id = NULL, $section_id = NULL, $month = NULL, $year = NULL)

    {

        $page_data['class_id']         = $class_id;                    // get all class_id

        $page_data['section_id']     = $section_id;                    // get all section_id

        $page_data['month']         = $month;                        // get all month

        $page_data['year']             = $year;                        // get all class year



        $page_data['page_name'] = 'printAttendanceReport';

        $page_data['page_title'] = "Attendance Report";

        $this->load->view('backend/index', $page_data);
    }

    /******************** /Ends here **********************/







    /***********  The function below add, update and delete exam question table ***********************/

    function examQuestion($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->exam_question_model->createexamQuestion();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/examQuestion', 'refresh');
        }



        if ($param1 == 'update') {

            $this->exam_question_model->updateexamQuestion($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/examQuestion', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->exam_question_model->deleteexamQuestion($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/examQuestion', 'refresh');
        }



        $page_data['page_name']     = 'examQuestion';

        $page_data['page_title']    = get_phrase('Exam Question');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function below add, update and delete exam question table ends here ***********************/





    /***********  The function below add, update and delete examination table ***********************/

    function createExamination($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->exam_model->createExamination();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/createExamination', 'refresh');
        }



        if ($param1 == 'update') {

            $this->exam_model->updateExamination($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/createExamination', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->exam_model->deleteExamination($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/createExamination', 'refresh');
        }



        $page_data['page_name']     = 'createExamination';

        $page_data['page_title']    = get_phrase('Create Exam');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function below add, update and delete examination table ends here ***********************/



    /***********  The function below add, update and delete student payment table ***********************/

    function student_payment($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'single_invoice') {

            $this->student_payment_model->createStudentSinglePaymentFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/student_invoice', 'refresh');
        }



        if ($param1 == 'mass_invoice') {



            $this->student_payment_model->createStudentMassPaymentFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/student_invoice', 'refresh');
        }



        if ($param1 == 'update_invoice') {

            $this->student_payment_model->updateStudentPaymentFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/student_invoice', 'refresh');
        }



        if ($param1 == 'take_payment') {

            $this->student_payment_model->takeNewPaymentFromStudent($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/student_invoice', 'refresh');
        }





        if ($param1 == 'delete_invoice') {

            $this->student_payment_model->deleteStudentPaymentFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/student_invoice', 'refresh');
        }



        $page_data['page_name']     = 'student_payment';

        $page_data['page_title']    = get_phrase('Student Payment');

        $this->load->view('backend/index', $page_data);
    }

    /***********  / Student payment ends here ***********************/



    function get_class_student($class_id)
    {

        $students = $this->db->get_where('student', array('class_id' => $class_id))->result_array();

        foreach ($students as $key => $student) {

            echo '<option value="' . $student['student_id'] . '">' . $student['name'] . '</option>';
        }
    }





    function get_class_mass_student($class_id)
    {



        $students = $this->db->get_where('student', array('class_id' => $class_id))->result_array();

        foreach ($students as $key => $student) {

            echo '<div class="">

            <label><input type="checkbox" class="check" name="student_id[]" value="' . $student['student_id'] . '">' . '&nbsp;' . $student['name'] . '</label></div>';
        }



        echo '<br><button type ="button" class="btn btn-success btn-sm btn-rounded" onClick="select()">' . get_phrase('Select All') . '</button>';

        echo '<button type ="button" class="btn btn-primary btn-sm btn-rounded" onClick="unselect()">' . get_phrase('Unselect All') . '</button>';
    }



    function student_invoice($student_id = null, $class_id = null)
    {



        if ($this->input->post('operation') == 'selection') {



            $page_data['student_id'] =  $this->input->post('student_id');

            $page_data['class_id']      =  $this->input->post('class_id');



            if ($page_data['student_id'] > 0) {



                redirect(base_url() . 'admin/student_invoice/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));

                redirect(base_url() . 'admin/student_invoice', 'refresh');
            }
        }



        $page_data['student_id'] =  $this->input->post('student_id');

        $page_data['class_id']      =  $this->input->post('class_id');

        $page_data['page_name']     = 'student_invoice';

        $page_data['page_title']    = get_phrase('Manage Invoice');



        $this->load->view('backend/index', $page_data);
    }



    /***********  The function below add, update and delete publisher table ***********************/

    function publisher($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->library_model->createPublisherFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/publisher', 'refresh');
        }



        if ($param1 == 'update') {

            $this->library_model->updatePublisherFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/publisher', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->library_model->deletePublisherFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/publisher', 'refresh');
        }



        $page_data['page_name']     = 'publisher';

        $page_data['page_title']    = get_phrase('Manage Publisher');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function below add, update and delete publisher table ends here ***********************/





    /***********  The function below add, update and delete publisher table ***********************/

    function author($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->library_model->createAuthorFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/author', 'refresh');
        }



        if ($param1 == 'update') {

            $this->library_model->updateAuthorFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/author', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->library_model->deleteAuthorFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/author', 'refresh');
        }



        $page_data['page_name']     = 'author';

        $page_data['page_title']    = get_phrase('Manage Author');

        $this->load->view('backend/index', $page_data);
    }



    /***********  The function below add, update and delete publisher table ends here ***********************/



    /***********  The function below add, update and delete BookCategory table ***********************/

    function book_category($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->library_model->createBookCategoryFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/book_category', 'refresh');
        }



        if ($param1 == 'update') {

            $this->library_model->updateBookCategoryFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/book_category', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->library_model->deleteBookCategoryFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/book_category', 'refresh');
        }



        $page_data['page_name']     = 'book_category';

        $page_data['page_title']    = get_phrase('Book Category');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function below add, update and delete BookCategory table ends here ***********************/







    /***********  The function below add, update and delete book table ***********************/

    function book($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->library_model->createBookFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/book', 'refresh');
        }



        if ($param1 == 'update') {

            $this->library_model->updateBookFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/book', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->library_model->deleteBookFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/book', 'refresh');
        }



        $page_data['page_name']     = 'book';

        $page_data['page_title']    = get_phrase('Manage Library');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function below add, update and delete book table ends here ***********************/



    /***********  The function below manages school event ***********************/

    function noticeboard($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->event_model->createNoticeboardFunction();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/noticeboard', 'refresh');
        }



        if ($param1 == 'update') {

            $this->event_model->updateNoticeboardFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/noticeboard', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->event_model->deleteNoticeboardFunction($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/noticeboard', 'refresh');
        }



        $page_data['page_name']     = 'noticeboard';

        $page_data['page_title']    = get_phrase('School Event');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function that manages school events ends here ***********************/



    /***********  The function below manages school language ***********************/

    function manage_language($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'edit_phrase') {

            $page_data['edit_profile']  =   $param2;
        }



        if ($param1 == 'add_language') {

            $this->language_model->createNewLanguage();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/manage_language', 'refresh');
        }



        if ($param1 == 'add_phrase') {

            $this->language_model->createNewLanguagePhrase();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/manage_language', 'refresh');
        }



        if ($param1 == 'delete_language') {

            $this->language_model->deleteLanguage($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/manage_language', 'refresh');
        }



        $page_data['page_name']     = 'manage_language';

        $page_data['page_title']    = get_phrase('Manage Language');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function that manages school language ends here ***********************/



    function updatePhraseWithAjax()
    {



        $checker['phrase_id']   =   $this->input->post('phraseId');

        $updater[$this->input->post('currentEditingLanguage')]  =   $this->input->post('updatedValue');



        $this->db->where('phrase_id', $checker['phrase_id']);

        $this->db->update('language', $updater);



        echo $checker['phrase_id'] . ' ' . $this->input->post('currentEditingLanguage') . ' ' . $this->input->post('updatedValue');
    }





    /***********  The function below manages school marks ***********************/

    function marks($exam_id = null, $class_id = null, $student_id = null)
    {



        if ($this->input->post('operation') == 'selection') {



            $page_data['exam_id']       =  $this->input->post('exam_id');

            $page_data['class_id']      =  $this->input->post('class_id');

            $page_data['student_id']    =  $this->input->post('student_id');



            if ($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['student_id'] > 0) {



                redirect(base_url() . 'admin/marks/' . $page_data['exam_id'] . '/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));

                redirect(base_url() . 'admin/marks', 'refresh');
            }
        }



        if ($this->input->post('operation') == 'update_student_subject_score') {



            $select_subject_first = $this->db->get_where('subject', array('class_id' => $class_id))->result_array();

            foreach ($select_subject_first as $key => $dispay_subject_from_subject_table) {



                $page_data['class_score1']  =   $this->input->post('class_score1_' . $dispay_subject_from_subject_table['subject_id']);

                $page_data['class_score2']  =   $this->input->post('class_score2_' . $dispay_subject_from_subject_table['subject_id']);

                $page_data['class_score3']  =   $this->input->post('class_score3_' . $dispay_subject_from_subject_table['subject_id']);

                $page_data['exam_score']    =   $this->input->post('exam_score_' . $dispay_subject_from_subject_table['subject_id']);

                $page_data['comment']       =   $this->input->post('comment_' . $dispay_subject_from_subject_table['subject_id']);

                // $page_data['session']       =   get_settings('session');


                $this->db->where('mark_id', $this->input->post('mark_id_' . $dispay_subject_from_subject_table['subject_id']));

                $this->db->update('mark', $page_data);
            }



            $this->session->set_flashdata('flash_message', get_phrase('Data Updated Successfully'));

            redirect(base_url() . 'admin/marks/' . $this->input->post('exam_id') . '/' . $this->input->post('class_id') . '/' . $this->input->post('student_id'), 'refresh');
        }



        $page_data['exam_id']       =   $exam_id;

        $page_data['class_id']      =   $class_id;

        $page_data['student_id']    =   $student_id;

        $page_data['subject_id']   =    $subject_id;

        $page_data['page_name']     =   'marks';

        $page_data['page_title']    = get_phrase('Student Marks');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function that manages school marks ends here ***********************/







    /***********  The function below manages school marks ***********************/

    function student_marksheet_subject($exam_id = null, $class_id = null, $subject_id = null)
    {



        if ($this->input->post('operation') == 'selection') {



            $page_data['exam_id']       =  $this->input->post('exam_id');

            $page_data['class_id']      =  $this->input->post('class_id');

            $page_data['subject_id']    =  $this->input->post('subject_id');



            if ($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['subject_id'] > 0) {



                redirect(base_url() . 'admin/student_marksheet_subject/' . $page_data['exam_id'] . '/' . $page_data['class_id'] . '/' . $page_data['subject_id'], 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));

                redirect(base_url() . 'admin/student_marksheet_subject', 'refresh');
            }
        }



        if ($this->input->post('operation') == 'update_student_subject_score') {

            // exit;

            $select_student_first = $this->db->get_where('student', array('class_id' => $class_id))->result_array();

            foreach ($select_student_first as $key => $dispay_student_from_student_table) {



                $page_data['class_score1']  =   $this->input->post('class_score1_' . $dispay_student_from_student_table['student_id']);

                $page_data['class_score2']  =   $this->input->post('class_score2_' . $dispay_student_from_student_table['student_id']);

                $page_data['class_score3']  =   $this->input->post('class_score3_' . $dispay_student_from_student_table['student_id']);

                $page_data['exam_score']    =   $this->input->post('exam_score_' . $dispay_student_from_student_table['student_id']);

                $page_data['comment']       =   $this->input->post('comment_' . $dispay_student_from_student_table['student_id']);

                // $page_data['session']       =   get_settings('session');



                $this->db->where('mark_id', $this->input->post('mark_id_' . $dispay_student_from_student_table['student_id']));

                $this->db->update('mark', $page_data);
            }



            $this->session->set_flashdata('flash_message', get_phrase('Data Updated Successfully'));

            redirect(base_url() . 'admin/student_marksheet_subject/' . $this->input->post('exam_id') . '/' . $this->input->post('class_id') . '/' . $this->input->post('subject_id'), 'refresh');
        }



        $page_data['exam_id']       =   $exam_id;

        $page_data['class_id']      =   $class_id;

        $page_data['student_id']    =   $student_id;

        $page_data['subject_id']   =    $subject_id;

        $page_data['page_name']     =   'student_marksheet_subject';

        $page_data['page_title']    = get_phrase('Student Marks');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function that manages school marks ends here ***********************/



    /***********  The function below manages school event ***********************/

    function exam_marks_sms($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'send') {

            $this->crud_model->send_student_score_model();

            $this->session->set_flashdata('flash_message', get_phrase('Data Sent successfully'));

            redirect(base_url() . 'admin/exam_marks_sms', 'refresh');
        }



        $page_data['page_name']     = 'exam_marks_sms';

        $page_data['page_title']    = get_phrase('Send Student Scores');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function that manages school events ends here ***********************/





    /***********  The function below manages new admin ***********************/

    function newAdministrator($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'create') {

            $this->admin_model->createNewAdministrator();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/newAdministrator', 'refresh');
        }



        if ($param1 == 'update') {

            $this->admin_model->updateAdministrator($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/newAdministrator', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->admin_model->deleteAdministrator($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/newAdministrator', 'refresh');
        }



        $page_data['page_name']     = 'newAdministrator';

        $page_data['page_title']    = get_phrase('New Administrator');

        $this->load->view('backend/index', $page_data);
    }

    /***********  The function that manages administrator ends here ***********************/



    function updateAdminRole($param2)
    {

        $this->admin_model->updateAllDetailsForAdminRole($param2);

        $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

        redirect(base_url() . 'admin/newAdministrator', 'refresh');
    }







    /***********  The function below manages school marks ***********************/

    function tabulation_sheet($exam_id = null, $class_id = null, $student_id = null)
    {

        // print_r(get_settings('session'));
        // exit();

        $page_data['current_session']    = get_phrase('session');

        if ($this->input->post('operation') == 'selection') {


            $page_data['exam_id']       =  $this->input->post('exam_id');

            $page_data['class_id']      =  $this->input->post('class_id');

            $page_data['student_id']    =  $this->input->post('student_id');




            if ($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['student_id'] > 0) {



                redirect(base_url() . 'admin/tabulation_sheet/' . $page_data['exam_id'] . '/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));

                redirect(base_url() . 'admin/tabulation_sheet', 'refresh');
            }
        }

        $page_data['exam_id']       =   $exam_id;

        $page_data['class_id']      =   $class_id;

        $page_data['student_id']    =   $student_id;

        // $page_data['subject_id']   =    $subject_id;

        $page_data['page_name']     =   'tabulation_sheet';

        $page_data['page_title']    = get_phrase('Student Marks');

        $this->load->view('backend/index', $page_data);
    }





    function tabulation_sheet_mid($exam_id = null, $class_id = null, $student_id = null)
    {

        if ($this->input->post('operation') == 'selection') {



            $page_data['exam_id']       =  $this->input->post('exam_id');

            $page_data['class_id']      =  $this->input->post('class_id');

            $page_data['student_id']    =  $this->input->post('student_id');



            if ($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['student_id'] > 0) {



                redirect(base_url() . 'admin/tabulation_sheet_mid/' . $page_data['exam_id'] . '/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));

                redirect(base_url() . 'admin/tabulation_sheet_mid', 'refresh');
            }
        }

        $page_data['exam_id']       =   $exam_id;

        $page_data['class_id']      =   $class_id;

        $page_data['student_id']    =   $student_id;

        // $page_data['subject_id']   =    $subject_id;

        $page_data['page_name']     =   'tabulation_sheet_mid';

        $page_data['page_title']    = get_phrase('Student Marks');

        $this->load->view('backend/index', $page_data);
    }



    function print_mass_report_card_old($class_id, $exam_id)
    {



        $page_data['exam_id']       =   $exam_id;

        $page_data['class_id']      =   $class_id;



        $page_data['page_name']     =   'print_mass_report_card';

        $page_data['page_title']    = get_phrase('Terminal Report');

        $this->load->view('backend/index', $page_data);
    }
    function print_mass_report_card($class_id, $exam_id)
    {
        $data['exam_id'] = $exam_id;
        $data['class_id'] = $class_id;
        $data['page_name'] = 'print_mass_report_card_mod_by_ab';
        $data['page_title'] = get_phrase('Terminal Report');
        $data['exam_name'] = $this->db->get_where('exam', array('exam_id' => $exam_id))->row()->name;
        $data['page_title'] = get_phrase('Terminal Report');
        $data['data_classes'] = $this->Crud_model->get_classes_by_ab();


        $result = $this->Crud_model->total_sql_query($class_id, $exam_id);
        $data['class_name'] = $this->db->get_where('class', array('class_id' => $class_id))->row()->name;
        $data['number_in_class'] = $this->db->get_where('student', array('class_id' => $class_id))->num_rows();
        // x_print($result);
        if ($result) {
            // Create an array to store the data
            $all_data = [];




            // Process the result data and structure it as needed
            foreach ($result as $row) {
                $student_id = $row->student_id;
                $subject_name = $row->subject_name;



                if ($exam_id == 1) {
                    $class_score1 = $row->first_term_class_score1;
                    $class_score2 = $row->first_term_class_score2;
                    $class_score3 = $row->first_term_class_score3;
                    $exam_score = $row->first_term_exam_score;
                    $subject_remark = $row->comment;
                } elseif ($exam_id == 3) {
                    $class_score1 = $row->second_term_class_score1;
                    $class_score2 = $row->second_term_class_score2;
                    $class_score3 = $row->second_term_class_score3;
                    $exam_score = $row->second_term_exam_score;
                    $subject_remark = $row->comment;
                } elseif ($exam_id == 4) {
                    $class_score1 = $row->third_term_class_score1;
                    $class_score2 = $row->third_term_class_score2;
                    $class_score3 = $row->third_term_class_score3;
                    $exam_score = $row->third_term_exam_score;
                    $subject_remark = $row->comment;
                }


                // $subject_remark = $row->comment;


                $class_score_one    = $class_score1;
                $class_score_two    = $class_score2;
                $exam_score         = $exam_score;

                $total_score        = $class_score_one + $class_score_two + $exam_score;
                $average_score      = $total_score / 3;


                $class_score_one_first_term    = $row->first_term_class_score1;
                $class_score_two_first_term    = $row->first_term_class_score2;
                $class_score_three_first_term  = $row->first_term_class_score3;
                $exam_score_first_term         = $row->first_term_exam_score;


                $total_score_first_term        = $class_score_one_first_term + $class_score_two_first_term + $exam_score_first_term;
                $average_score_first_term      = $total_score_first_term / 3;




                $class_score_one_second_term    = $row->second_term_class_score1;
                $class_score_two_second_term    = $row->second_term_class_score2;
                $class_score_three_second_term  =  $row->second_term_class_score3;
                $exam_score_second_term         = $row->second_term_exam_score;


                $total_score_second_term        = $class_score_one_second_term + $class_score_two_second_term + $exam_score_second_term;
                $average_score_second_term      = $total_score_second_term / 3;
                $overall_average_score_second_term = ($total_score + $total_score_first_term) / 2;


                $overall_average_score = ($total_score + $total_score_first_term + $total_score_second_term) / 3;


                // Initialize the student data if it doesn't exist
                if (!isset($all_data[$student_id])) {

                    $student_array = [
                        'name' => $row->student_name,
                        'sex' => $row->sex,
                        'teachercomment' => $row->teachercomment,
                        'teachercomment_id' => $row->teachercomment_id,
                    ];


                    $all_data[$student_id] = [
                        'student_info' => $student_array,
                        'mark' => []
                    ];
                }


                $subject_array = [
                    'class_score1' => $class_score1,
                    'class_score2' =>  $class_score2,
                    'class_score3' =>  $class_score3,
                    'exam_score' =>   $exam_score,
                    'first_term_class_score1' => $row->first_term_class_score1,
                    'first_term_class_score2' => $row->first_term_class_score2,
                    'first_term_class_score3' => $row->first_term_class_score3,
                    'first_term_exam_score' => $row->first_term_exam_score,
                    'second_term_class_score1' => $row->second_term_class_score1,
                    'second_term_class_score2' => $row->second_term_class_score2,
                    'second_term_class_score3' => $row->second_term_class_score3,
                    'second_term_exam_score' => $row->second_term_exam_score,
                    'third_term_class_score1' => $row->third_term_class_score1,
                    'third_term_class_score2' => $row->third_term_class_score2,
                    'third_term_class_score3' => $row->third_term_class_score3,
                    'third_term_exam_score' => $row->third_term_exam_score,
                    'subject_remark' => $subject_remark,
                ];

                $all_data[$student_id]['mark'][$subject_name] = $subject_array;
            }

            // Now $all_data contains the required data in the desired format
            // x_print($all_data);
        } else {
            $all_data = FALSE;
        }

        $data['select_student_from_model'] = $all_data;


        // $this->output->enable_profiler(TRUE);

        // x_print($data['select_student_from_model']);
        $this->load->view('backend/index_mod_ab_last', $data);
    }





    function print_mass_report_card_mid_old($class_id, $exam_id)
    {

        $page_data['exam_id']       =   $exam_id;

        $page_data['class_id']      =   $class_id;

        $page_data['page_name']     =   'print_mass_report_card_mid';

        $page_data['page_title']    = get_phrase('Terminal Report');

        $this->load->view('backend/index', $page_data);
    }
    function print_mass_report_card_mid($class_id, $exam_id)
    {

        $data['exam_id'] = $exam_id;
        $data['class_id'] = $class_id;
        $data['page_name'] = 'print_mass_report_card_mid_mod_by_ab';
        $data['page_title'] = get_phrase('Terminal Report');
        $data['exam_name'] = $this->db->get_where('exam', array('exam_id' => $exam_id))->row()->name;
        $data['page_title'] = get_phrase('Terminal Report');
        $data['data_classes'] = $this->Crud_model->get_classes_by_ab();
        $data['number_in_class'] = $this->db->get_where('student', array('class_id' => $class_id))->num_rows();


        $result = $this->Crud_model->total_sql_query($class_id, $exam_id);
        $data['class_name'] = $this->db->get_where('class', array('class_id' => $class_id))->row()->name;

        // x_print($result);
        if ($result) {
            // Create an array to store the data
            $all_data = [];
            // Process the result data and structure it as needed
            foreach ($result as $row) {
                $student_id = $row->student_id;
                $subject_name = $row->subject_name;

                if ($exam_id == 1) {
                    $class_score1 = $row->first_term_class_score1;
                    $class_score2 = $row->first_term_class_score2;
                    $class_score3 = $row->first_term_class_score3;
                    $exam_score = $row->first_term_exam_score;
                    $subject_remark = $row->comment;
                } elseif ($exam_id == 3) {
                    $class_score1 = $row->second_term_class_score1;
                    $class_score2 = $row->second_term_class_score2;
                    $class_score3 = $row->second_term_class_score3;
                    $exam_score = $row->second_term_exam_score;
                    $subject_remark = $row->comment;
                } elseif ($exam_id == 4) {
                    $class_score1 = $row->third_term_class_score1;
                    $class_score2 = $row->third_term_class_score2;
                    $class_score3 = $row->third_term_class_score3;
                    $exam_score = $row->third_term_exam_score;
                    $subject_remark = $row->comment;
                }

                $exam_score = $exam_score;

                // Initialize the student data if it doesn't exist
                if (!isset($all_data[$student_id])) {

                    $student_array = [
                        'name' => $row->student_name,
                        'sex' => $row->sex,
                        'teachercomment' => $row->teachercomment,
                        'teachercomment_id' => $row->teachercomment_id,
                    ];


                    $all_data[$student_id] = [
                        'student_info' => $student_array,
                        'mark' => []
                    ];
                }


                $subject_array = [
                    'class_score1' => $class_score1,
                    'class_score2' =>  $class_score2,
                    'class_score3' =>  $class_score3,
                    'exam_score' =>   $exam_score,
                    'first_term_class_score1' => $row->first_term_class_score1,
                    'first_term_class_score2' => $row->first_term_class_score2,
                    'first_term_class_score3' => $row->first_term_class_score3,
                    'first_term_exam_score' => $row->first_term_exam_score,
                    'second_term_class_score1' => $row->second_term_class_score1,
                    'second_term_class_score2' => $row->second_term_class_score2,
                    'second_term_class_score3' => $row->second_term_class_score3,
                    'second_term_exam_score' => $row->second_term_exam_score,
                    'third_term_class_score1' => $row->third_term_class_score1,
                    'third_term_class_score2' => $row->third_term_class_score2,
                    'third_term_class_score3' => $row->third_term_class_score3,
                    'third_term_exam_score' => $row->third_term_exam_score,
                    'subject_remark' => $subject_remark,
                ];

                $all_data[$student_id]['mark'][$subject_name] = $subject_array;
            }

            // Now $all_data contains the required data in the desired format
            // x_print($all_data);
        } else {
            $all_data = FALSE;
        }

        $data['select_student_from_model'] = $all_data;


        // $this->output->enable_profiler(TRUE);

        // x_print($data['select_student_from_model']);
        $this->load->view('backend/index_mod_ab_last', $data);
    }



    function set_language($lang)
    {

        $this->session->set_userdata('language', $lang);

        redirec(base_url() . 'admin', 'refresh');

        recache();
    }



    function create_barcode($student_id)
    {

        return $this->Barcode_model->create_barcode($student_id);
    }



    function studentMassIdentityCard()
    {

        $page_data['page_name']     =   'studentMassIdentityCard';

        $page_data['page_title']    = get_phrase('Mass Identity Card');

        $this->load->view('backend/index', $page_data);
    }



    function studentMassIdentityCardPage($class_id)
    {

        $page_data['class_id'] = $class_id;

        $this->load->view('backend/admin/studentMassIdentityCardPage', $page_data);
    }



    function websiteSetting($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'save_generalSetting') {

            $this->crud_model->save_into_school_website_table_model();

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/websiteSetting', 'refresh');
        }



        if ($param1 == 'save_banner') {

            $this->crud_model->save_banner_into_banner_table_model();

            $this->session->set_flashdata('flash_message', get_phrase('Data saved successfully'));

            redirect(base_url() . 'admin/websiteSetting', 'refresh');
        }



        if ($param1 == 'update_status') {

            $this->crud_model->update_testimony_status($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/websiteSetting', 'refresh');
        }



        if ($param1 == 'delete') {

            $this->crud_model->delete_testimony_status($param2);

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/websiteSetting', 'refresh');
        }



        $page_data['page_name']     =   'websiteSetting';

        $page_data['page_title']    = get_phrase('Website Settings');

        $this->load->view('backend/index', $page_data);
    }



    function chatRoomMessage()
    {



        $page_data['user_id'] = $this->input->post('user_id');

        $page_data['message'] = $this->input->post('chatSend');

        $sql = "select * from general_message order by general_message_id desc limit 1";

        $return_query = $this->db->query($sql)->row()->general_message_id + 1;

        $page_data['general_message_id'] = $return_query;

        $this->db->insert('general_message', $page_data);

        echo json_encode($page_data);
    }



    function addcomment($param1 = null, $param2 = null, $param3 = null)
    {

        if ($param1 == 'insert') {

            $class_id = $this->input->post('class_id');

            $exam_id = $this->input->post('exam_id');

            $page_data['student_id'] = $this->input->post('student_id');

            $page_data['comment'] = $this->input->post('comment');

            $this->db->insert('teachercomment', $page_data);

            $this->session->set_flashdata('flash_message', get_phrase('Comment added successfully'));

            redirect(base_url() . 'admin/print_mass_report_card/' . $class_id . '/' . $exam_id, 'refresh');

            // echo json_encode($page_data);

        }



        if ($param1 == 'delete') {


            $class_id = $this->input->get('class_id');

            $exam_id = $this->input->get('exam_id');

            $this->db->where('id', $param2);

            $this->db->delete('teachercomment');

            $this->session->set_flashdata('flash_message', get_phrase('Comment deleted successfully'));

            redirect(base_url() . 'admin/print_mass_report_card/' . $class_id . '/' . $exam_id, 'refresh');
        }
    }


    function promote_student($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'update') {



            $student_promote_id = $this->input->post('student_promote_id');

            $exam_id = $this->input->post('exam_id');

            $page_data['class_id'] = $this->input->post('class_id');

            $class_id = $this->input->post('class_id');



            $this->db->where('student_id', $student_promote_id);

            $this->db->update('student', $page_data);

            // redirect(base_url(). 'admin/print_mass_report_card/'.$class_id.'/'.$exam_id, 'refresh');

            // $this->session->set_flashdata('flash_message', get_phrase('Student promoted successfully.'));



            redirect(base_url() . 'admin/tabulation_sheet', 'refresh');
        }





        //  $sql="Select * from teachercomment where student_id = 93";    

        // $query = $this->db->query($sql);

        // $data = $query->result_array();

        // echo "<pre>";

        // foreach($data as $value){



        // print_r($value['comment']);

        // }

        // // return $query->result_array();

        //  die;





        // if($param1 == 'insert'){



        //     $class_id = $this->input->post('class_id');

        //     $exam_id = $this->input->post('exam_id');



        //     $page_data['student_id'] = $this->input->post('student_id');

        //     $page_data['comment'] = $this->input->post('comment');

        //     $this->db->insert('teachercomment', $page_data);



        // redirect(base_url(). 'admin/print_mass_report_card/'.$class_id.'/'.$exam_id, 'refresh');

        // // echo json_encode($page_data);



        // }



        // if($param1 == 'delete'){



        //     $this->db->where('id', $param2);

        //     $this->db->delete('teachercomment');

        //     $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

        //     // redirect(base_url(). 'admin/print_mass_report_card/', 'refresh');

        //     redirect($_SERVER['HTTP_REFERER']);

        // }





    }



    function studentRequestBook($param1 = null, $param2 = null, $param3 = null)
    {



        if ($param1 == 'update') {



            $page_data['status'] = $this->input->post('status');



            $this->db->where('book_request_id', $param2);

            $this->db->update('book_request', $page_data);

            $this->session->set_flashdata('flash_message', get_phrase('Data updated successfully'));

            redirect(base_url() . 'admin/studentRequestBook', 'refresh');
        }



        if ($param1 == 'delete') {



            $this->db->where('book_request_id', $param2);

            $this->db->delete('book_request');

            $this->session->set_flashdata('flash_message', get_phrase('Data deleted successfully'));

            redirect(base_url() . 'admin/studentRequestBook', 'refresh');
        }



        $page_data['page_name']     =   'studentRequestBook';

        $page_data['page_title']    = get_phrase('Student Book Request');

        $this->load->view('backend/index', $page_data);
    }













    /********** the functino createan online exam for students ********************/

    function manage_online_exam($param1 = "", $param2 = "")
    {

        if ($this->session->userdata('admin_login') != 1)

            redirect(base_url(), 'refresh');



        $running_year = get_settings('session');



        if ($param1 == '') {

            $match = array('status !=' => 'expired', 'running_year' => $running_year);

            $page_data['status'] = 'active';

            $this->db->order_by("exam_date", "dsc");

            $page_data['online_exams'] = $this->db->where($match)->get('online_exam')->result_array();
        }



        if ($param1 == 'expired') {    // if parameter is equal to expired do the below information

            $match = array('status' => 'expired', 'running_year' => $running_year);

            $page_data['status'] = 'expired';

            $this->db->order_by("exam_date", "dsc");

            $page_data['online_exams'] = $this->db->where($match)->get('online_exam')->result_array();
        }



        if ($param1 == 'create') {    // if parameter is equal to create do the below information

            if ($this->input->post('class_id') > 0 && $this->input->post('section_id') > 0 && $this->input->post('subject_id') > 0) {

                $this->crud_model->create_online_exam();

                $this->session->set_flashdata('flash_message', get_phrase('data_added_successfully'));

                redirect(site_url('admin/manage_online_exam'), 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('make_sure_to_select_valid_class_') . ',' . get_phrase('_section_and_subject'));

                redirect(site_url('admin/manage_online_exam'), 'refresh');
            }
        }

        if ($param1 == 'edit') {                // if parameter is equal to edit then do the below information

            if ($this->input->post('class_id') > 0 && $this->input->post('section_id') > 0 && $this->input->post('subject_id') > 0) {

                $this->crud_model->update_online_exam();

                $this->session->set_flashdata('flash_message', get_phrase('data_updated_successfully'));

                redirect(site_url('admin/manage_online_exam'), 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('make_sure_to_select_valid_class_') . ',' . get_phrase('_section_and_subject'));

                redirect(site_url('admin/manage_online_exam'), 'refresh');
            }
        }

        if ($param1 == 'delete') {    // if parameter is equal to delete do the below information

            $this->db->where('online_exam_id', $param2);

            $this->db->delete('online_exam');

            $this->session->set_flashdata('flash_message', get_phrase('data_deleted'));

            redirect(site_url('admin/manage_online_exam'), 'refresh');
        }

        $page_data['page_name'] = 'manage_online_exam';

        $page_data['page_title'] = get_phrase('manage_online_exam');

        $this->load->view('backend/index', $page_data);
    }



    /********** the functino create an online_exam_questions_print_view ********************/

    function online_exam_questions_print_view($online_exam_id, $answers)
    {

        if ($this->session->userdata('admin_login') != 1)

            redirect(site_url('login'), 'refresh');



        $page_data['online_exam_id'] = $online_exam_id;

        $page_data['answers'] = $answers;

        $page_data['page_title'] = get_phrase('questions_print');

        $this->load->view('backend/admin/online_exam_questions_print_view', $page_data);
    }

    /********** the functino create an online_exam_questions_print_view ********************/



    /********** the functino create an create_online_exam ********************/

    function create_online_exam()
    {

        $page_data['page_name'] = 'add_online_exam';

        $page_data['page_title'] = get_phrase('add_an_online_exam');

        $this->load->view('backend/index', $page_data);
    }

    /********** the functino create an /create_online_exam ********************/



    /********** the functino create an update_online_exam ********************/

    function update_online_exam($param1 = "")
    {

        $page_data['online_exam_id'] = $param1;

        $page_data['page_name'] = 'edit_online_exam';

        $page_data['page_title'] = get_phrase('update_online_exam');

        $this->load->view('backend/index', $page_data);
    }

    /********** the functino create an /update_online_exam ********************/



    /********** the functino create an manage_online_exam_status ********************/

    function manage_online_exam_status($online_exam_id = "", $status = "")
    {

        $this->crud_model->manage_online_exam_status($online_exam_id, $status);

        redirect(site_url('admin/manage_online_exam'), 'refresh');
    }

    /********** the functino create an /manage_online_exam_status ********************/



    function load_question_type($type, $online_exam_id)
    {

        $page_data['question_type'] = $type;

        $page_data['online_exam_id'] = $online_exam_id;

        $this->load->view('backend/admin/online_exam_add_' . $type, $page_data);
    }



    function manage_online_exam_question($online_exam_id = "", $task = "", $type = "")
    {

        if ($this->session->userdata('admin_login') != 1)

            redirect(site_url('login'), 'refresh');



        if ($task == 'add') {

            if ($type == 'multiple_choice') {

                $this->crud_model->add_multiple_choice_question_to_online_exam($online_exam_id);
            } elseif ($type == 'true_false') {

                $this->crud_model->add_true_false_question_to_online_exam($online_exam_id);
            } elseif ($type == 'fill_in_the_blanks') {

                $this->crud_model->add_fill_in_the_blanks_question_to_online_exam($online_exam_id);
            }

            redirect(site_url('admin/manage_online_exam_question/' . $online_exam_id), 'refresh');
        }



        $page_data['online_exam_id'] = $online_exam_id;

        $page_data['page_name'] = 'manage_online_exam_question';

        $page_data['page_title'] = $this->db->get_where('online_exam', array('online_exam_id' => $online_exam_id))->row()->title;

        $this->load->view('backend/index', $page_data);
    }



    /********** function to update online exam for students ********************/

    function update_online_exam_question($question_id = "", $task = "", $online_exam_id = "")
    {

        if ($this->session->userdata('admin_login') != 1)

            redirect(site_url('login'), 'refresh');

        $online_exam_id = $this->db->get_where('question_bank', array('question_bank_id' => $question_id))->row()->online_exam_id;

        $type = $this->db->get_where('question_bank', array('question_bank_id' => $question_id))->row()->type;

        if ($task == "update") {

            if ($type == 'multiple_choice') {

                $this->crud_model->update_multiple_choice_question($question_id);
            } elseif ($type == 'true_false') {

                $this->crud_model->update_true_false_question($question_id);
            } elseif ($type == 'fill_in_the_blanks') {

                $this->crud_model->update_fill_in_the_blanks_question($question_id);
            }

            redirect(site_url('admin/manage_online_exam_question/' . $online_exam_id), 'refresh');
        }

        $page_data['question_id'] = $question_id;

        $page_data['page_name'] = 'update_online_exam_question';

        $page_data['page_title'] = get_phrase('update_question');

        $this->load->view('backend/index', $page_data);
    }



    function delete_question_from_online_exam($question_id)
    {

        $online_exam_id = $this->db->get_where('question_bank', array('question_bank_id' => $question_id))->row()->online_exam_id;

        $this->crud_model->delete_question_from_online_exam($question_id);

        $this->session->set_flashdata('flash_message', get_phrase('question_deleted'));

        redirect(site_url('admin/manage_online_exam_question/' . $online_exam_id), 'refresh');
    }



    function manage_multiple_choices_options()
    {

        $page_data['number_of_options'] = $this->input->post('number_of_options');

        $this->load->view('backend/admin/manage_multiple_choices_options', $page_data);
    }



    function view_online_exam_result($online_exam_id)
    {

        $page_data['page_name'] = 'view_online_exam_results';

        $page_data['page_title'] = get_phrase('result');

        $page_data['online_exam_id'] = $online_exam_id;

        $this->load->view('backend/index', $page_data);
    }





    function fee_collection($class_id = null, $student_id = null)
    {



        $page_data['class_id'] =  $this->input->post('class_id');

        $page_data['student_id'] =  $this->input->post('student_id');



        $page_data['page_name']     =   'fee_collection';

        $page_data['page_title']    = get_phrase('Fee Collection');

        $this->load->view('backend/index', $page_data);

        // $this->load->view('backend/fee_collection',$page_data);

    }





    /* private messaging function starts from here: Here the function attach files, send and reply message accrodingly */

    function message($param1 = 'message_home', $param2 = '', $param3 = '')
    {

        if ($this->session->userdata('admin_login') != 1)

            redirect(base_url(), 'refresh');



        $max_size = 2097152;

        if ($param1 == 'send_new') {



            if (!file_exists('uploads/private_messaging_attached_file/')) {

                $oldmask = umask(0);  // helpful when used in linux server

                mkdir('uploads/private_messaging_attached_file/', 0777);
            }



            if ($_FILES['attached_file_on_messaging']['name'] != "") {

                if ($_FILES['attached_file_on_messaging']['size'] > $max_size) {

                    $this->session->set_flashdata('error_message', get_phrase('file_size_can_not_be_larger_that_2_Megabyte'));

                    redirect(base_url() . 'admin/message/message_new/', 'refresh');
                } else {

                    $file_path = 'uploads/private_messaging_attached_file/' . $_FILES['attached_file_on_messaging']['name'];

                    move_uploaded_file($_FILES['attached_file_on_messaging']['tmp_name'], $file_path);
                }
            }



            $message_thread_code = $this->crud_model->send_new_private_message();

            $this->session->set_flashdata('flash_message', get_phrase('message_sent!'));

            redirect(base_url() . 'admin/message/message_read/' . $message_thread_code, 'refresh');
        }



        if ($param1 == 'send_reply') {



            if (!file_exists('uploads/private_messaging_attached_file/')) {

                $oldmask = umask(0);  // helpful when used in linux server

                mkdir('uploads/private_messaging_attached_file/', 0777);
            }

            if ($_FILES['attached_file_on_messaging']['name'] != "") {

                if ($_FILES['attached_file_on_messaging']['size'] > $max_size) {

                    $this->session->set_flashdata('error_message', get_phrase('file_size_can_not_be_larger_that_2_Megabyte'));

                    redirect(base_url() . 'admin/message/message_read/' . $param2, 'refresh');
                } else {

                    $file_path = 'uploads/private_messaging_attached_file/' . $_FILES['attached_file_on_messaging']['name'];

                    move_uploaded_file($_FILES['attached_file_on_messaging']['tmp_name'], $file_path);
                }
            }



            $this->crud_model->send_reply_message($param2);  //$param2 = message_thread_code

            $this->session->set_flashdata('flash_message', get_phrase('message_sent!'));

            redirect(base_url() . 'admin/message/message_read/' . $param2, 'refresh');
        }



        if ($param1 == 'message_read') {

            $page_data['current_message_thread_code'] = $param2;  // $param2 = message_thread_code

            $this->crud_model->mark_thread_messages_read($param2);
        }



        $page_data['message_inner_page_name'] = $param1;

        $page_data['page_name'] = 'message';

        $page_data['page_title'] = get_phrase('private_messaging');

        $this->load->view('backend/index', $page_data);
    }
}
