<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Student_model extends CI_Model { 
	
	function __construct()
    {
        parent::__construct();
        $this->load->helper('security');
    }



    // The function below insert into student house //
    function createStudentHouse(){

        $page_data = array(
            'name'          => trim($this->security->xss_clean(trim(html_escape($this->input->post('name'))))),
            'description'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('description')))))
	    );

        $this->db->insert('house', $page_data);
    }

// The function below update student house //
    function updateStudentHouse($param2){
        $page_data = array(
            'name'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('name'))))),
            'description'  => trim($this->security->xss_clean(trim(html_escape($this->input->post('description')))))
	    );

        $this->db->where('house_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('house', $page_data);
    }

    // The function below delete from student house table //
    function deleteStudentHouse($param2){
        $this->db->where('house_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('house');
    }



    // The function below insert into student category //
    function createstudentCategory(){

        $page_data = array(
            'name'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('name'))))),
            'description' => trim($this->security->xss_clean(trim(html_escape($this->input->post('description')))))
	    );
        $this->db->insert('student_category', $page_data);
    }

// The function below update student category //
    function updatestudentCategory($param2){
        $page_data = array(
            'name'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('name'))))),
            'description' => trim($this->security->xss_clean(trim(html_escape($this->input->post('description')))))
	    );

        $this->db->where('student_category_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('student_category', $page_data);
    }

    // The function below delete from student category table //
    function deletestudentCategory($param2){
        $this->db->where('student_category_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('student_category');
    }




    //  the function below insert into student table
    function createNewStudent(){

        $class_id = trim($this->security->xss_clean(trim(html_escape($this->input->post('class_id')))));
        $session = trim($this->security->xss_clean(trim(html_escape($this->input->post('session')))));

        $page_data = array(
            'name'          => trim($this->security->xss_clean(trim(html_escape($this->input->post('name'))))),
            'birthday'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('birthday'))))),
            'age'           => trim($this->security->xss_clean(trim(html_escape($this->input->post('age'))))),
            'place_birth'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('place_birth'))))),
            'sex'           => trim($this->security->xss_clean(trim(html_escape($this->input->post('sex'))))),
            'm_tongue'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('m_tongue'))))),
            'religion'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('religion'))))),
            'blood_group'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('blood_group'))))),
            'address'       => trim($this->security->xss_clean(trim(html_escape($this->input->post('address'))))),
            'city'          => trim($this->security->xss_clean(trim(html_escape($this->input->post('city'))))),
            'state'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('state'))))),
            'nationality'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('nationality'))))),
            'phone'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('phone'))))),
            'email'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('email'))))),
            'ps_attended'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('ps_attended'))))),  
            'ps_address'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('ps_address'))))), 
            'ps_purpose'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('ps_purpose'))))),
            'class_study'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('class_study'))))), 
            'date_of_leaving' => trim($this->security->xss_clean(trim(html_escape($this->input->post('date_of_leaving'))))),
            'am_date'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('am_date'))))),
            'tran_cert'       => trim($this->security->xss_clean(trim(html_escape($this->input->post('tran_cert'))))),
            'dob_cert'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('dob_cert'))))),
            'mark_join'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('mark_join'))))),
            'physical_h'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('physical_h'))))),
            'password'        => sha1(trim($this->security->xss_clean(trim($this->input->post('password'))))),
            'class_id'        => $class_id,
            'section_id'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('section_id'))))),
            'parent_id'       => trim($this->security->xss_clean(trim(html_escape($this->input->post('parent_id'))))),
            'roll'            => trim($this->security->xss_clean(trim(html_escape($this->input->post('roll'))))),
            'transport_id'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('transport_id'))))),
            'dormitory_id'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('dormitory_id'))))),
            'house_id'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('house_id'))))),
            'student_category_id' => trim($this->security->xss_clean(trim(html_escape($this->input->post('student_category_id'))))),
            'club_id'             => trim($this->security->xss_clean(trim(html_escape($this->input->post('club_id'))))),
            'session'             => $session,
        );
        
    
    $this->db->insert('student', $page_data);
    $student_id = $this->db->insert_id();
    move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/student_image/' . $student_id . '.jpg');           // image with user ID


    if($student_id > 0)
    {
        $sync_with_student_class_registration= array();

        $sync_with_student_class_registration = array(
            'student_id'=>$student_id,
            'class_id'=>$class_id,
            'session'=>$session,
            'promoted_dt'=>date('Y-m-d H:i:s'),
            'promoted_by'=>$this->session->userdata('login_user_id'),
            'by_usertype'=>$this->session->userdata('login_type')
            );//            'previous_session'=>$previous_academic_session,

        $this->db->insert("student_class_registration",$sync_with_student_class_registration);
    }
    
    }


    //the function below update student
    function updateNewStudent($param2){

        $class_id = trim($this->security->xss_clean(trim(html_escape($this->input->post('class_id')))));

        $page_data = array(
            'name'          => trim($this->security->xss_clean(trim(html_escape($this->input->post('name'))))),
            'birthday'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('birthday'))))),
            'age'           => trim($this->security->xss_clean(trim(html_escape($this->input->post('age'))))),
            'place_birth'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('place_birth'))))),
            'sex'           => trim($this->security->xss_clean(trim(html_escape($this->input->post('sex'))))),
            'm_tongue'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('m_tongue'))))),
            'religion'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('religion'))))),
            'blood_group'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('blood_group'))))),
            'address'       => trim($this->security->xss_clean(trim(html_escape($this->input->post('address'))))),
            'city'          => trim($this->security->xss_clean(trim(html_escape($this->input->post('city'))))),
            'state'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('state'))))),
            'nationality'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('nationality'))))),
            'phone'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('phone'))))),
            'email'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('email'))))),
            'ps_attended'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('ps_attended'))))),  
            'ps_address'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('ps_address'))))), 
            'ps_purpose'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('ps_purpose'))))),
            'class_study'   => trim($this->security->xss_clean(trim(html_escape($this->input->post('class_study'))))), 
            'date_of_leaving' => trim($this->security->xss_clean(trim(html_escape($this->input->post('date_of_leaving'))))),
            'am_date'         => trim($this->security->xss_clean(trim(html_escape($this->input->post('am_date'))))),
            'tran_cert'       => trim($this->security->xss_clean(trim(html_escape($this->input->post('tran_cert'))))),
            'dob_cert'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('dob_cert'))))),
            'mark_join'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('mark_join'))))),
            'physical_h'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('physical_h'))))),
            'class_id'        => $class_id,
            'section_id'      => trim($this->security->xss_clean(trim(html_escape($this->input->post('section_id'))))),
            'parent_id'       => trim($this->security->xss_clean(trim(html_escape($this->input->post('parent_id'))))),
            'transport_id'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('transport_id'))))),
            'dormitory_id'    => trim($this->security->xss_clean(trim(html_escape($this->input->post('dormitory_id'))))),
            'house_id'        => trim($this->security->xss_clean(trim(html_escape($this->input->post('house_id'))))),
            'student_category_id' => trim($this->security->xss_clean(trim(html_escape($this->input->post('student_category_id'))))),
            'club_id'             => trim($this->security->xss_clean(trim(html_escape($this->input->post('club_id')))))
	    );
        $this->db->where('student_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('student', $page_data);
        move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/student_image/' . trim($this->security->xss_clean(trim($param2))) . '.jpg');

        $student_id = trim($this->security->xss_clean(trim($param2)));

        if($student_id > 0)
        {
            $get_session = $this->db->select("session")->from("student")->where("student_id",$student_id)->get()->row();
            $student_session='';

            if(is_object($get_session))
            {
                $student_session = $get_session->session;
            }

            $sync_with_student_class_registration= array();

            $sync_with_student_class_registration = array(
                'student_id'=>$student_id,
                'class_id'=>$class_id,
                'session'=>$session,
                'promoted_dt'=>date('Y-m-d H:i:s'),
                'promoted_by'=>$this->session->userdata('login_user_id'),
                'by_usertype'=>$this->session->userdata('login_type')
                );//            'previous_session'=>$previous_academic_session,

            $whr_cond = array(
                'student_id'=>$student_id,'session'=>$session);
            
            $this->db->update("student_class_registration",$sync_with_student_class_registration,$whr_cond);
        }

    }

    // the function below deletes from student table
    function deleteNewStudent($param2){
        $this->db->where('student_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('student');
    }


    function create_student_request_book(){

        $page_data['book_id'] = trim($this->security->xss_clean(trim($this->input->post('book_id'))));
        $page_data['request_date'] =strtotime(trim($this->security->xss_clean(trim($this->input->post('request_date')))));
        $page_data['return_date'] = strtotime(trim($this->security->xss_clean(trim($this->input->post('return_date')))));
        $page_data['status'] = 2;
        $page_data['student_id'] = $this->db->get_where('student', array('student_id' => $this->session->userdata('student_id')))->row()->student_id;
        
        $this->db->insert('book_request', $page_data);
    }

	


	
	
}

