<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Payroll_model extends CI_Model { 
	
	function __construct()
    {
        parent::__construct();
        $this->load->helper('security');

    }



    function insertPayrollFunction(){

        $data['payroll_code']   = substr(md5(rand(100000000, 20000000000)), 0, 7);
        $data['user_id']        = trim($this->security->xss_clean(trim($this->input->post('teacher_id'))));
        
        $allowances             = array();
        $allowance_types        = trim($this->security->xss_clean(trim($this->input->post('allowance_type'))));
        $allowance_amounts      = trim($this->security->xss_clean(trim($this->input->post('allowance_amount'))));
        $number_of_entries      = sizeof($allowance_types);
        
        for($i = 0; $i < $number_of_entries; $i++)
        {
            if($allowance_types[$i] != "" && $allowance_amounts[$i] != "")
            {
                $new_entry = array('type' => $allowance_types[$i], 'amount' => $allowance_amounts[$i]);
                array_push($allowances, $new_entry);
            }
        }
        $data['allowances']     = json_encode($allowances);
        
        $deductions             = array();
        $deduction_types        = trim($this->security->xss_clean(trim($this->input->post('deduction_type'))));
        $deduction_amounts      = trim($this->security->xss_clean(trim($this->input->post('deduction_amount'))));
        $number_of_entries      = sizeof($deduction_types);
        
        for($i = 0; $i < $number_of_entries; $i++)
        {
            if($deduction_types[$i] != "" && $deduction_amounts[$i] != "")
            {
                $new_entry = array('type' => $deduction_types[$i], 'amount' => $deduction_amounts[$i]);
                array_push($deductions, $new_entry);
            }
        }
        $data['deductions']     = json_encode($deductions);
        $data['date']           = trim($this->security->xss_clean(trim($this->input->post('month')))) . ',' . trim($this->security->xss_clean(trim($this->input->post('year'))));
        $data['status']         = trim($this->security->xss_clean(trim($this->input->post('status'))));
        
        $this->db->insert('payroll', $data);
    }



	


	
	
}

