<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Expense_model extends CI_Model { 
	
	function __construct()
    {
        parent::__construct();
        $this->load->helper('security');
    }


    function insertExpenseCategory(){

        $page_data = array(
            'name' => trim($this->security->xss_clean(trim($this->input->post('name')))),
			);

        $this->db->insert('expense_category', $page_data);
    }

// The function below upate expense category //
    function updateExpenseCategory($param2){
        $page_data = array(
            'name' => trim($this->security->xss_clean(trim($this->input->post('name')))),
			);

        $this->db->where('expense_category_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('expense_category', $page_data);
    }

    function deleteExpenseCategory($param2){
        $this->db->where('expense_category_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('expense_category');
    }


    function insertExpense(){

        $page_data['title']                         =   trim($this->security->xss_clean(trim($this->input->post('title'))));
        $page_data['expense_category_id']           =   trim($this->security->xss_clean(trim($this->input->post('expense_category_id'))));
        $page_data['description']                   =   trim($this->security->xss_clean(trim($this->input->post('description'))));
        $page_data['payment_type']                  =  'expense';
        $page_data['method']                        =   trim($this->security->xss_clean(trim($this->input->post('method'))));
        $page_data['amount']                        =   trim($this->security->xss_clean(trim($this->input->post('amount'))));
        $page_data['timestamp']                     =   trim($this->security->xss_clean(trim($this->input->post('timestamp'))));
        $page_data['year']                          =   $this->db->get_where('settings', array('type' => 'session'))->row()->description;
        $this->db->insert('payment', $page_data);
    }

    function updateExpense($param2){

        $page_data['title']                         =   trim($this->security->xss_clean(trim($this->input->post('title'))));
        $page_data['expense_category_id']           =   trim($this->security->xss_clean(trim($this->input->post('expense_category_id'))));
        $page_data['description']                   =   trim($this->security->xss_clean(trim($this->input->post('description'))));
        $page_data['payment_type']                  =  'expense';
        $page_data['method']                        =   trim($this->security->xss_clean(trim($this->input->post('method'))));
        $page_data['amount']                        =   trim($this->security->xss_clean(trim($this->input->post('amount'))));
        $page_data['timestamp']                     =   strtotime(trim($this->security->xss_clean(trim($this->input->post('timestamp')))));

        $this->db->where('payment_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('payment', $page_data);
    }

    function deleteExpense($param2){
        $this->db->where('payment_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('payment');
    }
	
	
}
