
<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Crud_model extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->helper('security');
    }


    function get_data_mysql($select_item='',$db_tbl='',$whr='',$order='',$qry_typ='')
    {

        $data_qry = $this->db->select($select_item)
                    ->FROM($db_tbl)
                    ->WHERE($whr,'',FALSE) //NULL
                    ->order_by($order,'',FALSE) //NULL
                    ->get();

        if($qry_typ == 1) // return data as row
        {
            $data = $data_qry->row();
        }
        else if($qry_typ == 2) // return data as result
        {
            $data = $data_qry->result();
        }

        if(is_object($data) || is_array($data))
        {
            return $data;
        }
        else
        {
            return '';
        }

    }


    function get_type_name_by_id($type, $type_id = '', $field = 'name')
    {
        $this->db->where($type . '_id', $type_id);
        $query = $this->db->get($type);
        $result = $query->result_array();
        foreach ($result as $row)
            return $row[$field];
    }

    /**** Function to select all messages in ascending order ****/
    function get_general_messages()
    {
        $query = $this->db->query("SELECT * FROM general_message ORDER BY general_message_id asc");
        return $query->result_array();
    }


    function get_image_url($type = '', $id = '')
    {
        if (file_exists('uploads/' . $type . '_image/' . $id . '.jpg'))
            $image_url = base_url() . 'uploads/' . $type . '_image/' . $id . '.jpg';
        else
            $image_url = base_url() . 'uploads/user.jpg';
        return $image_url;
    }

    function get_subject_name_by_id($subject_id)
    {
        $query = $this->db->get_where('subject', array('subject_id' => trim($this->security->xss_clean(trim($subject_id)))))->row();
        return $query->name;
    }

    function get_class_name($class_id)
    {
        $query = $this->db->get_where('class', array('class_id' => trim($this->security->xss_clean(trim($class_id)))));
        $result = $query->result_array();
        foreach ($result as $key => $row)
            return $row['name'];
    }

    function get_teachers()
    {
        $query = $this->db->get('teacher');
        return $query->result_array();
    }


    function get_teacher_name($teacher_id)
    {
        $query = $this->db->get_where('teacher', array('teacher_id' => trim($this->security->xss_clean(trim($teacher_id)))));
        $res = $query->result_array();
        foreach ($res as $row)
            return $row['name'];
    }

    function get_admin_name($admin_id)
    {
        $query = $this->db->get_where('admin', array('admin_id' => trim($this->security->xss_clean(trim($admin_id)))));
        $resi = $query->result_array();
        foreach ($resi as $row)
            return $row['name'];
    }

    function get_teacher_info($teacher_id)
    {
        $query = $this->db->get_where('teacher', array('teacher_id' => trim($this->security->xss_clean(trim($teacher_id)))));
        return $query->result_array();
    }


    function get_invoice_info()
    {
        $query = $this->db->get('invoice');
        return $query->result_array();
    }

    /***********  Subjects  *******************/
    function get_subjects()
    {
        $query = $this->db->get('subject');
        return $query->result_array();
    }

    function get_subject_info($subject_id)
    {
        $query = $this->db->get_where('subject', array('subject_id' => trim($this->security->xss_clean(trim($subject_id)))));
        return $query->result_array();
    }

    function get_subjects_by_class($class_id)
    {
        $query = $this->db->get_where('subject', array('class_id' => trim($this->security->xss_clean(trim($class_id)))));

        return $query->result_array();
    }

    function getSubjectsByClassIDnTeacherIDnSession($class_id,$teachers_identity,$session)
    {
        $query = $this->db->get_where('subject', array('class_id' => trim($this->security->xss_clean(trim($class_id))),'teacher_id'=>trim($this->security->xss_clean(trim($teachers_identity))),'session'=>trim($this->security->xss_clean(trim($session)))));
        return $query->result();
    }


    function get_class_name_numeric($class_id)
    {
        $query = $this->db->get_where('class', array('class_id' => trim($this->security->xss_clean(trim($class_id)))));
        $res = $query->result_array();
        foreach ($res as $row)
            return $row['name_numeric'];
    }

    function get_classes()
    {
        $query = $this->db->get('class');
        return $query->result_array();
    }

    function get_class_info($class_id)
    {
        $query = $this->db->get_where('class', array('class_id' => trim($this->security->xss_clean(trim($class_id)))));
        return $query->result_array();
    }

    /***********  Exams  *******************/
    function get_exams()
    {
        $query = $this->db->get('exam');
        return $query->result_array();
    }

    function get_exam_info($exam_id)
    {
        $query = $this->db->get_where('exam', array('exam_id' => trim($this->security->xss_clean(trim($exam_id)))));
        return $query->result_array();
    }

    /***********  Grades  *******************/
    function get_grades()
    {
        $query = $this->db->get('grade');
        return $query->result_array();
    }

    function get_grade_info($grade_id)
    {
        $query = $this->db->get_where('grade', array('grade_id' => trim($this->security->xss_clean(trim($grade_id)))));
        return $query->result_array();
    }

    function get_obtained_marks($exam_id, $class_id, $subject_id, $student_id)
    {
        $marks = $this->db->get_where('mark', array(
            'subject_id' => trim($this->security->xss_clean(trim($subject_id))),
            'exam_id' => trim($this->security->xss_clean(trim($exam_id))),
            'class_id' => trim($this->security->xss_clean(trim($class_id))),
            'student_id' => trim($this->security->xss_clean(trim($student_id)))
        ))->result_array();

        foreach ($marks as $row) {
            echo $row['mark_obtained'];
        }
    }
    function get_obtained_marks_mod($exam_id, $class_id, $subject_id, $student_id)
    {
        // $mark = $this->db->select('mark_obtained')
        //     ->from('mark')
        //     ->where(array(
        //         'subject_id' => $subject_id,
        //         'exam_id' => $exam_id,
        //         'class_id' => $class_id,
        //         'student_id' => $student_id
        //     ))->row();


        $session = get_settings('session');
        $this->db->select('exam_score');
        $this->db->where(array(
            'subject_id' => trim($this->security->xss_clean(trim($subject_id))),
            'exam_id' => trim($this->security->xss_clean(trim($exam_id))),
            'class_id' => trim($this->security->xss_clean(trim($class_id))),
            'student_id' => trim($this->security->xss_clean(trim($student_id))),
            'session' => $session
        ));
        $query = $this->db->get('mark');
        if ($this->db->affected_rows() > 0) {

            // if ($query->row()->total_score) {
            return $query->row()->exam_score;
            // }else{
            //     return "0";
            // }

        } else {
            return "0";
        }
    }

    function get_highest_marks($exam_id, $class_id, $subject_id)
    {

        $this->db->where('exam_id', trim($this->security->xss_clean(trim($exam_id))));
        $this->db->where('class_id', trim($this->security->xss_clean(trim($class_id))));
        $this->db->where('subject_id', trim($this->security->xss_clean(trim($subject_id))));
        $this->db->select_max('exam_score');
        $highest_marks = $this->db->get('mark')->result_array();
        foreach ($highest_marks as $row) {
            return $row['exam_score'];
        }
    }

    function get_highest_marks_mods($exam_id, $class_id, $subject_id)
    {
        $session = get_settings('session');
        $this->db->where('exam_id', trim($this->security->xss_clean(trim($exam_id))));
        $this->db->where('class_id', trim($this->security->xss_clean(trim($class_id))));
        $this->db->where('subject_id', trim($this->security->xss_clean(trim($subject_id))));
        $this->db->select_max('exam_score');

        $this->db->where('session', $session);

        $query = $this->db->get('mark');
        if ($this->db->affected_rows() > 0) {
            return $query->row()->exam_score;
        } else {
            return "0";
        }
    }

    function get_grade($exam_score)
    {
        $query = $this->db->get('grade');
        $grades = $query->result_array();
        foreach ($grades as $row) {
            if ($mark_obtained >= $row['mark_from'] && $exam_score <= $row['mark_upto'])
                return $row;
        }
    }

    function get_students($class_id)
    {
        $query = $this->db->get_where('student', array('class_id' => trim($this->security->xss_clean(trim($class_id)))));
        return $query->result_array();
        // $this->db->where('class_id', $class_id);
        // $this->db->limit(3); // Replace $limit with the number of rows you want to retrieve
        // $query = $this->db->get('student');
        // return $query->result_array();
    }

    function getStudentsByClassIDnSession($class_id,$session)
    {
        $query = $this->db->select("s.student_id,s.name,scr.is_promoted")
                          ->from("student s")
                          ->join("student_class_registration scr","s.student_id=scr.student_id")
                          ->where("scr.class_id",trim($this->security->xss_clean(trim($class_id))))
                          ->where("scr.session",trim($this->security->xss_clean(trim($session))))
                          ->where("scr.sts","1");
        return $query->get()->result();
    }

    function get_students_bysession($class_id,$session)
    {
        
        $query = $this->db->select("s.student_id,s.name,scr.is_promoted")
                          ->from("student s")
                          ->join("student_class_registration scr","s.student_id=scr.student_id")
                          ->where("scr.class_id",trim($this->security->xss_clean(trim($class_id))))
                          ->where("scr.session",trim($this->security->xss_clean(trim($session))))
                          ->where("scr.sts","1");
        return $query->get()->result_array();
        // $this->db->where('class_id', $class_id);
        // $this->db->limit(3); // Replace $limit with the number of rows you want to retrieve
        // $query = $this->db->get('student');
        // return $query->result_array();
    }

    function get_classes_by_ab()
    {
        $query = $this->db->get('class');
        return $query->result_array();
    }

    // code by ab 
    function get_students_info_mod_ab($class_id)
    {
        $this->db->select(['student_id', 'name', 'class_id', 'section_id',]);
        $this->db->where('class_id', trim($this->security->xss_clean(trim($class_id))));
        // $this->db->limit(1); // Replace $limit with the number of rows you want to retrieve
        $query = $this->db->get('student');
        return $query->result_array();
    }
    
    function get_student_info_by_id($student_id = null) {
        $query = $this->db->get_where('student', array('student_id' => trim($this->security->xss_clean(trim($student_id)))))->row_array();
        
        return $query;
    }


    function get_subject_info_mod_ab($class_id)
    {
        $this->db->where('class_id', trim($this->security->xss_clean(trim($class_id))));
        $query = $this->db->get('subject');
        return $query->result_array();
    }
    function get_mark_info_mod_ab($class_id, $exam_id, $student_id, $subject_id)
    {
        $this->db->where('class_id',trim($this->security->xss_clean(trim($class_id))));
        $this->db->where('exam_id', trim($this->security->xss_clean(trim($exam_id))));
        $this->db->where('student_id', trim($this->security->xss_clean(trim($student_id))));
        $this->db->where('subject_id', trim($this->security->xss_clean(trim($subject_id))));
        $query = $this->db->get('mark');
        return $query->result_array();
    }

    function total_sql_query($class_id, $exam_id,$session='')
    {
        //$session = get_settings('session');
        // $sql = "SELECT 
        //     student.student_id,student.roll,student.sex, student.name AS student_name,
        //     subject.subject_id, subject.name AS subject_name,
        //     mark.mark_id, mark.class_score1, mark.class_score2, mark.class_score3, mark.exam_score, mark.comment
        // FROM student
        // JOIN subject ON student.class_id = subject.class_id
        // LEFT JOIN mark ON student.
        // student_id = mark.student_id AND subject.subject_id = mark.subject_id
        // WHERE student.class_id = $class_id
        // AND mark.exam_id = $exam_id
        // AND mark.session = '$session'
        // ORDER BY subject.subject_id ASC";
        //     $sql = "SELECT 
        //     student.student_id,
        //     student.roll,
        //     student.sex,
        //     student.name AS student_name,
        //     subject.subject_id,
        //     subject.name AS subject_name,
        //     mark.mark_id, mark.comment, teachercomment.comment as teachercomment, teachercomment.id as teachercomment_id,
        //     MAX(CASE WHEN mark.exam_id = 1 THEN mark.class_score1 ELSE NULL END) AS first_term_class_score1,
        //     MAX(CASE WHEN mark.exam_id = 1 THEN mark.class_score2 ELSE NULL END) AS first_term_class_score2,
        //     MAX(CASE WHEN mark.exam_id = 1 THEN mark.class_score3 ELSE NULL END) AS first_term_class_score3,
        //     MAX(CASE WHEN mark.exam_id = 1 THEN mark.exam_score ELSE NULL END) AS first_term_exam_score,
        //     MAX(CASE WHEN mark.exam_id = 1 THEN mark.comment ELSE NULL END) AS first_term_subject_remark,
        //     MAX(CASE WHEN mark.exam_id = 3 THEN mark.class_score1 ELSE NULL END) AS second_term_class_score1,
        //     MAX(CASE WHEN mark.exam_id = 3 THEN mark.class_score2 ELSE NULL END) AS second_term_class_score2,
        //     MAX(CASE WHEN mark.exam_id = 3 THEN mark.class_score3 ELSE NULL END) AS second_term_class_score3,
        //     MAX(CASE WHEN mark.exam_id = 3 THEN mark.exam_score ELSE NULL END) AS second_term_exam_score,
        //     MAX(CASE WHEN mark.exam_id = 3 THEN mark.comment ELSE NULL END) AS second_term_subject_remark,
        //     MAX(CASE WHEN mark.exam_id = 4 THEN mark.class_score1 ELSE NULL END) AS third_term_class_score1,
        //     MAX(CASE WHEN mark.exam_id = 4 THEN mark.class_score2 ELSE NULL END) AS third_term_class_score2,
        //     MAX(CASE WHEN mark.exam_id = 4 THEN mark.class_score3 ELSE NULL END) AS third_term_class_score3,
        //     MAX(CASE WHEN mark.exam_id = 4 THEN mark.exam_score ELSE NULL END) AS third_term_exam_score,
        //     MAX(CASE WHEN mark.exam_id = 4 THEN mark.comment ELSE NULL END) AS third_term_subject_remark
        // FROM student
        // JOIN subject ON student.class_id = subject.class_id
        // LEFT JOIN mark ON student.student_id = mark.student_id AND subject.subject_id = mark.subject_id
        // LEFT JOIN teachercomment ON student.student_id = teachercomment.student_id
        // WHERE student.class_id = $class_id
        // AND mark.exam_id IN (1, 3, 4)  -- Filter for the first, second, and third terms
        // AND mark.session = '2022-2023'
        // GROUP BY student.student_id, student.roll, student.sex, student_name, subject.subject_id, subject_name
        // ORDER BY subject.subject_id ASC";
        /*$sql = "SELECT 
        student.student_id,
        student.roll,
        student.sex,
        student.name AS student_name,
        subject.subject_id,
        subject.name AS subject_name,
        mark.mark_id,
        mark.comment,
        COALESCE(teachercomment.comment, last_teacher_comment.comment) as teachercomment,
        COALESCE(teachercomment.id, last_teacher_comment.id) as teachercomment_id,
        MAX(CASE WHEN mark.exam_id = 1 THEN mark.class_score1 ELSE NULL END) AS first_term_class_score1,
        MAX(CASE WHEN mark.exam_id = 1 THEN mark.class_score2 ELSE NULL END) AS first_term_class_score2,
        MAX(CASE WHEN mark.exam_id = 1 THEN mark.class_score3 ELSE NULL END) AS first_term_class_score3,
        MAX(CASE WHEN mark.exam_id = 1 THEN mark.exam_score ELSE NULL END) AS first_term_exam_score,
        MAX(CASE WHEN mark.exam_id = 1 THEN mark.comment ELSE NULL END) AS first_term_subject_remark,
        MAX(CASE WHEN mark.exam_id = 3 THEN mark.class_score1 ELSE NULL END) AS second_term_class_score1,
        MAX(CASE WHEN mark.exam_id = 3 THEN mark.class_score2 ELSE NULL END) AS second_term_class_score2,
        MAX(CASE WHEN mark.exam_id = 3 THEN mark.class_score3 ELSE NULL END) AS second_term_class_score3,
        MAX(CASE WHEN mark.exam_id = 3 THEN mark.exam_score ELSE NULL END) AS second_term_exam_score,
        MAX(CASE WHEN mark.exam_id = 3 THEN mark.comment ELSE NULL END) AS second_term_subject_remark,
        MAX(CASE WHEN mark.exam_id = 4 THEN mark.class_score1 ELSE NULL END) AS third_term_class_score1,
        MAX(CASE WHEN mark.exam_id = 4 THEN mark.class_score2 ELSE NULL END) AS third_term_class_score2,
        MAX(CASE WHEN mark.exam_id = 4 THEN mark.class_score3 ELSE NULL END) AS third_term_class_score3,
        MAX(CASE WHEN mark.exam_id = 4 THEN mark.exam_score ELSE NULL END) AS third_term_exam_score,
        MAX(CASE WHEN mark.exam_id = 4 THEN mark.comment ELSE NULL END) AS third_term_subject_remark
    FROM student
    JOIN subject ON student.class_id = subject.class_id
    LEFT JOIN mark ON student.student_id = mark.student_id AND subject.subject_id = mark.subject_id
    LEFT JOIN teachercomment ON student.student_id = teachercomment.student_id
    LEFT JOIN (
        SELECT student_id, MAX(id) as id, comment
        FROM teachercomment
        GROUP BY student_id
    ) last_teacher_comment ON student.student_id = last_teacher_comment.student_id
    WHERE student.class_id = $class_id
    AND mark.exam_id IN (1, 3, 4)  -- Filter for the first, second, and third terms
    AND mark.session = '$session'
    GROUP BY student.student_id, student.roll, student.sex, student_name, subject.subject_id, subject_name
    ORDER BY student.student_id ASC, subject.subject_id ASC";*/
    
    	$sql = "Select sinfo.*,sub.subject_id,sub.name AS subject_name,m.mark_id,m.comment,
		    COALESCE(tc.comment, last_teacher_comment.comment) as teachercomment,
			COALESCE(tc.id, last_teacher_comment.id) as teachercomment_id,
			MAX(CASE WHEN m.exam_id = 1 THEN m.class_score1 ELSE NULL END) AS first_term_class_score1,
			MAX(CASE WHEN m.exam_id = 1 THEN m.class_score2 ELSE NULL END) AS first_term_class_score2,
			MAX(CASE WHEN m.exam_id = 1 THEN m.class_score3 ELSE NULL END) AS first_term_class_score3,
			MAX(CASE WHEN m.exam_id = 1 THEN m.exam_score ELSE NULL END) AS first_term_exam_score,
			MAX(CASE WHEN m.exam_id = 1 THEN m.comment ELSE NULL END) AS first_term_subject_remark,
			MAX(CASE WHEN m.exam_id = 3 THEN m.class_score1 ELSE NULL END) AS second_term_class_score1,
			MAX(CASE WHEN m.exam_id = 3 THEN m.class_score2 ELSE NULL END) AS second_term_class_score2,
			MAX(CASE WHEN m.exam_id = 3 THEN m.class_score3 ELSE NULL END) AS second_term_class_score3,
			MAX(CASE WHEN m.exam_id = 3 THEN m.exam_score ELSE NULL END) AS second_term_exam_score,
			MAX(CASE WHEN m.exam_id = 3 THEN m.comment ELSE NULL END) AS second_term_subject_remark,
			MAX(CASE WHEN m.exam_id = 4 THEN m.class_score1 ELSE NULL END) AS third_term_class_score1,
			MAX(CASE WHEN m.exam_id = 4 THEN m.class_score2 ELSE NULL END) AS third_term_class_score2,
			MAX(CASE WHEN m.exam_id = 4 THEN m.class_score3 ELSE NULL END) AS third_term_class_score3,
			MAX(CASE WHEN m.exam_id = 4 THEN m.exam_score ELSE NULL END) AS third_term_exam_score,
			MAX(CASE WHEN m.exam_id = 4 THEN m.comment ELSE NULL END) AS third_term_subject_remark
		    From
		    (
		    Select si.student_id,s.roll,s.sex,s.name AS student_name,si.class_id,si.session,si.is_promoted
		    from
		    (Select scr.student_id,scr.class_id,scr.session,scr.is_promoted 
		    from student_class_registration scr
		    where scr.class_id='$class_id' AND scr.session='$session')si
		    JOIN student s ON s.student_id = si.student_id
		    )sinfo
		    JOIN subject sub ON sinfo.class_id = sub.class_id
		    LEFT JOIN mark m ON sinfo.student_id = m.student_id AND sub.subject_id = m.subject_id AND sinfo.session=m.session
		    LEFT JOIN teachercomment tc ON sinfo.student_id = tc.student_id
		    LEFT JOIN (
			SELECT student_id, MAX(id) as id, comment
			FROM teachercomment
			GROUP BY student_id
		    ) last_teacher_comment ON sinfo.student_id = last_teacher_comment.student_id

		
		    GROUP BY sinfo.student_id, sinfo.roll, sinfo.sex, sinfo.student_name, sub.subject_id, subject_name
		    ORDER BY sinfo.student_id ASC, sub.subject_id ASC";

            // Where m.exam_id IN (1, 3, 4)  -- Filter for the first, second, and third terms
            // AND m.session = '$session'

        $result = $this->db->query($sql)->result();
        return $result;
    }
    // end code by ab 
    /**** Function to select all students from student's table ****/
    function list_all_student_and_order_with_student_id()
    {

        $data = array();
        $sql = "select * from student order by student_id desc limit 0, 5";
        $all_student_selected = $this->db->query($sql)->result_array();

        foreach ($all_student_selected as $key => $selected_students_from_student_table) {
            $student_id = $selected_students_from_student_table['student_id'];
            $face_file = 'uploads/student_image/' . $student_id . '.jpg';
            if (!file_exists($face_file)) {
                $face_file = 'uploads/student_image/default_image.jpg/';
            }
            $selected_students_from_student_table['face_file'] = base_url() . $face_file;
            array_push($data, $selected_students_from_student_table);
        }
        return $data;
    }

    /**** Function to select all teachers from teacher's table ****/
    function list_all_teacher_and_order_with_teacher_id()
    {

        $data = array();
        $sql = "select * from teacher order by teacher_id desc limit 0, 5";
        $all_teacher_selected = $this->db->query($sql)->result_array();

        foreach ($all_teacher_selected as $key => $selected_teachers_from_teacher_table) {
            $teacher_id = $selected_teachers_from_teacher_table['teacher_id'];
            $face_file = 'uploads/teacher_image/' . $teacher_id . '.jpg';
            if (!file_exists($face_file)) {
                $face_file = 'uploads/teacher_image/default_image.jpg/';
            }

            $selected_teachers_from_teacher_table['face_file'] = base_url() . $face_file;
            array_push($data, $selected_teachers_from_teacher_table);
        }

        return $data;
    }


    function enquiry_category()
    {

        $page_data['category']  =   trim($this->security->xss_clean(trim($this->input->post('category'))));
        $page_data['purpose']   =   trim($this->security->xss_clean(trim($this->input->post('purpose'))));
        $page_data['whom']      =   trim($this->security->xss_clean(trim($this->input->post('whom'))));
        $this->db->insert('enquiry_category', $page_data);
    }

    function update_category($param2)
    {
        $page_data['category']  =   trim($this->security->xss_clean(trim($this->input->post('category'))));
        $page_data['purpose']   =   trim($this->security->xss_clean(trim($this->input->post('purpose'))));
        $page_data['whom']      =   trim($this->security->xss_clean(trim($this->input->post('whom'))));
        $this->db->where('enquiry_category_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('enquiry_category', $page_data);
    }

    function delete_category($param2)
    {
        $this->db->where('enquiry_category_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('enquiry_category');
    }

    function delete_enquiry($param2)
    {
        $this->db->where('enquiry_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('enquiry');
    }

    function insert_club()
    {

        $page_data['club_name']     =   trim($this->security->xss_clean(trim($this->input->post('club_name'))));
        $page_data['desc']          =   trim($this->security->xss_clean(trim($this->input->post('desc'))));
        $page_data['date']          =   trim($this->security->xss_clean(trim($this->input->post('date'))));

        $this->db->insert('club', $page_data);
    }

    function update_club($param2)
    {

        $page_data['club_name']     =   trim($this->security->xss_clean(trim($this->input->post('club_name'))));
        $page_data['desc']          =   trim($this->security->xss_clean(trim($this->input->post('desc'))));
        $page_data['date']          =   trim($this->security->xss_clean(trim($this->input->post('date'))));

        $this->db->where('club_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('club', $page_data);
    }


    function delete_club($param2)
    {
        $this->db->where('club_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('club');
    }


    function insert_circular()
    {

        $page_data['title']         =   trim($this->security->xss_clean(trim($this->input->post('title'))));
        $page_data['reference']     =   trim($this->security->xss_clean(trim($this->input->post('reference'))));
        $page_data['content']       =   trim($this->security->xss_clean(trim($this->input->post('content'))));
        $page_data['date']          =   trim($this->security->xss_clean(trim($this->input->post('date'))));

        $this->db->insert('circular', $page_data);
    }

    function update_circular($param2)
    {
        $page_data['title']         =   trim($this->security->xss_clean(trim($this->input->post('title'))));
        $page_data['reference']     =   trim($this->security->xss_clean(trim($this->input->post('reference'))));
        $page_data['content']       =   trim($this->security->xss_clean(trim($this->input->post('content'))));
        $page_data['date']          =   trim($this->security->xss_clean(trim($this->input->post('date'))));


        $this->db->where('circular_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('circular', $page_data);
    }


    function delete_circular($param2)
    {
        $this->db->where('circular_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('circular');
    }


    function insert_parent()
    {

        $page_data = array(
            'name' => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'email' => trim($this->security->xss_clean(trim($this->input->post('email')))),
            'password' => sha1(trim($this->security->xss_clean(trim($this->input->post('password'))))),
            'phone' => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'address' => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'profession' => trim($this->security->xss_clean(trim($this->input->post('profession'))))
        );

        $this->db->insert('parent', $page_data);
    }


    function update_parent($param2)
    {
        $page_data = array(
            'name' => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'email' => trim($this->security->xss_clean(trim($this->input->post('email')))),
            'phone' => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'address' => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'profession' => trim($this->security->xss_clean(trim($this->input->post('profession'))))
        );

        $this->db->where('parent_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('parent', $page_data);
    }

    function delete_parent($param2)
    {
        $this->db->where('parent_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('parent');
    }

    function insert_librarian()
    {
        $page_data = array(        // array data that postulate the input fileds
            'name'                 => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'librarian_number'     => trim($this->security->xss_clean(trim($this->input->post('librarian_number')))),
            'birthday'             => trim($this->security->xss_clean(trim($this->input->post('birthday')))),
            'sex'                 => trim($this->security->xss_clean(trim($this->input->post('sex')))),
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'facebook'             => trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     => trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'    => trim($this->security->xss_clean(trim($this->input->post('marital_status')))),
            'password'             => sha1(trim($this->security->xss_clean(trim($this->input->post('password')))))
        );

        $page_data['file_name'] = $_FILES["file_name"]["name"];
        $page_data['email'] = trim($this->security->xss_clean(trim($this->input->post('email'))));
        $check_email = $this->db->get_where('librarian', array('email' => $page_data['email']))->row()->email;    // checking if email exists in database
        if ($check_email != null) {
            $this->session->set_flashdata('error_message', get_phrase('email_already_exist'));
            redirect(base_url() . 'admin/librarian/', 'refresh');
        } else {
            $this->db->insert('librarian', $page_data);
            $librarian_id = $this->db->insert_id();

            move_uploaded_file($_FILES["file_name"]["tmp_name"], "uploads/librarian_image/" . $_FILES["file_name"]["name"]);    // upload files
            move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/librarian_image/' . $librarian_id . '.jpg');            // image with user ID
            //$this->email_model->account_opening_email('librarian', $data['email']); //Send email to receipient email adddrress upon account opening
        }
    }

    function update_librarian($param2)
    {
        $page_data = array(            // array starts from here
            'name'                => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'birthday'            => trim($this->security->xss_clean(trim($this->input->post('birthday')))),
            'sex'                 => trim($this->security->xss_clean(trim($this->input->post('sex')))),
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'email'             => trim($this->security->xss_clean(trim($this->input->post('email')))),
            'facebook'             => trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     => trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'     => trim($this->security->xss_clean(trim($this->input->post('marital_status'))))
        );

        $this->db->where('librarian_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('librarian', $page_data);
        move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/librarian_image/' . trim($this->security->xss_clean(trim($param2))) . '.jpg');
    }

    function delete_librarian($param2)
    {
        $this->db->where('librarian_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('librarian');
    }



    function insert_accountant()
    {
        $page_data = array(        // array data that postulate the input fileds
            'name'                 => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'accountant_number'     => trim($this->security->xss_clean(trim($this->input->post('accountant_number')))),
            'birthday'             => trim($this->security->xss_clean(trim($this->input->post('birthday')))),
            'sex'                 => trim($this->security->xss_clean(trim($this->input->post('sex')))),
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'facebook'             => trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     => trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'    => trim($this->security->xss_clean(trim($this->input->post('marital_status')))),
            'password'             => sha1(trim($this->security->xss_clean(trim($this->input->post('password')))))
        );

        $page_data['file_name'] = $_FILES["file_name"]["name"];
        $page_data['email'] = trim($this->security->xss_clean(trim($this->input->post('email'))));
        $check_email = $this->db->get_where('accountant', array('email' => $page_data['email']))->row()->email;    // checking if email exists in database
        if ($check_email != null) {
            $this->session->set_flashdata('error_message', get_phrase('email_already_exist'));
            redirect(base_url() . 'admin/accountant/', 'refresh');
        } else {
            $this->db->insert('accountant', $page_data);
            $accountant_id = $this->db->insert_id();

            move_uploaded_file($_FILES["file_name"]["tmp_name"], "uploads/accountant_image/" . $_FILES["file_name"]["name"]);    // upload files
            move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/accountant_image/' . $accountant_id . '.jpg');            // image with user ID
            //$this->email_model->account_opening_email('accountant', $data['email']); //Send email to receipient email adddrress upon account opening
        }
    }




    function update_accountant($param2)
    {
        $page_data = array(            // array starts from here
            'name'                => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'birthday'            => trim($this->security->xss_clean(trim($this->input->post('birthday')))),
            'sex'                 => trim($this->security->xss_clean(trim($this->input->post('sex')))),
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'email'             => trim($this->security->xss_clean(trim($this->input->post('email')))),
            'facebook'             => trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     =>trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'     => trim($this->security->xss_clean(trim($this->input->post('marital_status'))))
        );

        $this->db->where('accountant_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('accountant', $page_data);
        move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/accountant_image/' . trim($this->security->xss_clean(trim($param2))) . '.jpg');
    }

    function delete_accountant($param2)
    {
        $this->db->where('accountant_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('accountant');
    }




    function insert_hostel()
    {
        $page_data = array(        // array data that postulate the input fileds
            'name'                 => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'hostel_number'     => trim($this->security->xss_clean(trim($this->input->post('hostel_number')))),
            'birthday'             => trim($this->security->xss_clean(trim($this->input->post('birthday')))),
            'sex'                 =>trim($this->security->xss_clean(trim($this->input->post('sex')))),
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'facebook'             =>trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     => trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'    =>trim($this->security->xss_clean(trim($this->input->post('marital_status')))),
            'password'             => sha1(trim($this->security->xss_clean(trim($this->input->post('password')))))
        );

        $page_data['file_name'] = $_FILES["file_name"]["name"];
        $page_data['email'] = trim($this->security->xss_clean(trim($this->input->post('email'))));
        $check_email = $this->db->get_where('hostel', array('email' => $page_data['email']))->row()->email;    // checking if email exists in database
        if ($check_email != null) {
            $this->session->set_flashdata('error_message', get_phrase('email_already_exist'));
            redirect(base_url() . 'admin/hostel/', 'refresh');
        } else {
            $this->db->insert('hostel', $page_data);
            $hostel_id = $this->db->insert_id();

            move_uploaded_file($_FILES["file_name"]["tmp_name"], "uploads/hostel_image/" . $_FILES["file_name"]["name"]);    // upload files
            move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/hostel_image/' . $hostel_id . '.jpg');            // image with user ID
            //$this->email_model->account_opening_email('hostel', $data['email']); //Send email to receipient email adddrress upon account opening
        }
    }


    function update_hostel($param2)
    {
        $page_data = array(            // array starts from here
            'name'                => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'birthday'            => trim($this->security->xss_clean(trim($this->input->post('birthday')))), 
            'sex'                 => trim($this->security->xss_clean(trim($this->input->post('sex')))), 
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             => trim($this->security->xss_clean(trim($this->input->post('address')))), 
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'email'             => trim($this->security->xss_clean(trim($this->input->post('email')))),  
            'facebook'             => trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     => trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'     =>trim($this->security->xss_clean(trim($this->input->post('marital_status'))))
        );

        $this->db->where('hostel_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('hostel', $page_data);
        move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/hostel_image/' . trim($this->security->xss_clean(trim($param2))) . '.jpg');
    }

    function delete_hostel($param2)
    {
        $this->db->where('hostel_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('hostel');
    }



    function insert_hrm()
    {
        $page_data = array(        // array data that postulate the input fileds
            'name'                 => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'hrm_number'         => trim($this->security->xss_clean(trim($this->input->post('hrm_number')))),
            'birthday'             =>trim($this->security->xss_clean(trim($this->input->post('birthday')))),
            'sex'                 => trim($this->security->xss_clean(trim($this->input->post('sex')))),
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             =>trim($this->security->xss_clean(trim($this->input->post('address')))),
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'facebook'             => trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     => trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'    => trim($this->security->xss_clean(trim($this->input->post('marital_status')))),
            'password'             => sha1(trim($this->security->xss_clean(trim($this->input->post('password')))))
        );

        $page_data['file_name'] = $_FILES["file_name"]["name"];
        $page_data['email'] = trim($this->security->xss_clean(trim($this->input->post('email'))));
        $check_email = $this->db->get_where('hrm', array('email' => $page_data['email']))->row()->email;    // checking if email exists in database
        if ($check_email != null) {
            $this->session->set_flashdata('error_message', get_phrase('email_already_exist'));
            redirect(base_url() . 'admin/hrm/', 'refresh');
        } else {
            $this->db->insert('hrm', $page_data);
            $hrm_id = $this->db->insert_id();

            move_uploaded_file($_FILES["file_name"]["tmp_name"], "uploads/hrm_image/" . $_FILES["file_name"]["name"]);    // upload files
            move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/hrm_image/' . $hrm_id . '.jpg');            // image with user ID
            //$this->email_model->account_opening_email('hrm', $data['email']); //Send email to receipient email adddrress upon account opening
        }
    }


    function update_hrm($param2)
    {
        $page_data = array(            // array starts from here
            'name'                => trim($this->security->xss_clean(trim($this->input->post('name')))),
            'birthday'            => trim($this->security->xss_clean(trim($this->input->post('birthday')))),
            'sex'                 => trim($this->security->xss_clean(trim($this->input->post('sex')))), 
            'religion'             => trim($this->security->xss_clean(trim($this->input->post('religion')))),
            'blood_group'         => trim($this->security->xss_clean(trim($this->input->post('blood_group')))),
            'address'             => trim($this->security->xss_clean(trim($this->input->post('address')))),
            'phone'             => trim($this->security->xss_clean(trim($this->input->post('phone')))),
            'email'             => trim($this->security->xss_clean(trim($this->input->post('email')))),
            'facebook'             => trim($this->security->xss_clean(trim($this->input->post('facebook')))),
            'twitter'             => trim($this->security->xss_clean(trim($this->input->post('twitter')))),
            'googleplus'         => trim($this->security->xss_clean(trim($this->input->post('googleplus')))),
            'linkedin'             => trim($this->security->xss_clean(trim($this->input->post('linkedin')))),
            'qualification'     => trim($this->security->xss_clean(trim($this->input->post('qualification')))),
            'marital_status'     => trim($this->security->xss_clean(trim($this->input->post('marital_status'))))
        );

        $this->db->where('hrm_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('hrm', $page_data);
        move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/hrm_image/' . trim($this->security->xss_clean(trim($param2))) . '.jpg');
    }

    function delete_hrm($param2)
    {
        $this->db->where('hrm_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('hrm');
    }


    function system_logo()
    {

        move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/logo.png');
    }


    function update_settings()
    {

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('system_name'))));
        $this->db->where('type', 'system_name');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('system_title'))));
        $this->db->where('type', 'system_title');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('address'))));
        $this->db->where('type', 'address');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('phone'))));
        $this->db->where('type', 'phone');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('paypal_email'))));
        $this->db->where('type', 'paypal_email');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('currency'))));
        $this->db->where('type', 'currency');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('system_email'))));
        $this->db->where('type', 'system_email');
        $this->db->update('settings', $data);

        $data['description']    =   trim($this->security->xss_clean(trim($this->input->post('language'))));
        $this->db->where('type', 'language');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('text_align'))));
        $this->db->where('type', 'text_align');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('running_session'))));
        $this->db->where('type', 'session');
        $this->db->update('settings', $data);
        
        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('promoted_session'))));
        $this->db->where('type', 'promoted_session');
        $this->db->update('settings', $data);
        
        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('resumption'))));
        $this->db->where('type', 'resumption');
        $this->db->update('settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('footer'))));
        $this->db->where('type', 'footer');
        $this->db->update('settings', $data);
    }

    function save_into_school_website_table_model()
    {

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('about_us'))));
        $this->db->where('type', 'about_us');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('video_link'))));
        $this->db->where('type', 'video_link');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('mission'))));
        $this->db->where('type', 'mission');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('vission'))));
        $this->db->where('type', 'vission');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('goal'))));
        $this->db->where('type', 'goal');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('testimony_message'))));
        $this->db->where('type', 'testimony_message');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('map_code'))));
        $this->db->where('type', 'map_code');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('facebook_like_code'))));
        $this->db->where('type', 'facebook_like_code');
        $this->db->update('website_settings', $data);

        $data['description']    =  trim($this->security->xss_clean(trim($this->input->post('contact_message'))));
        $this->db->where('type', 'contact_message');
        $this->db->update('website_settings', $data);
    }

    function save_banner_into_banner_table_model()
    {
        $page_data['banner_image'] = $_FILES["banner_image"]["name"];
        $page_data['banner_text'] = trim($this->security->xss_clean(trim($this->input->post('banner_text'))));
        $this->db->insert('banner_table', $page_data);
        move_uploaded_file($_FILES['banner_image']['tmp_name'], 'uploads/banner_image/' . $_FILES["banner_image"]["name"]);
    }

    function update_testimony_status($param2)
    {

        $page_data['status'] = trim($this->security->xss_clean(trim($this->input->post('status'))));

        $this->db->where('testimony_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->update('testimony_table', $page_data);
    }

    function delete_testimony_status($param2)
    {

        $this->db->where('testimony_id', trim($this->security->xss_clean(trim($param2))));
        $this->db->delete('testimony_table');
    }


    function update_theme()
    {

        $data['description']    =   trim($this->security->xss_clean(trim($this->input->post('skin_colour'))));
        $this->db->where('type', 'skin_colour');
        $this->db->update('settings', $data);
    }

    function get_settings($type)
    {
        $get_settings = $this->db->get_where('settings', array('type' => trim($this->security->xss_clean(trim($type)))))->row()->description;
        return $get_settings;
    }


    function stripe_settings()
    {
        $stripe_info = array();

        $stripe['stripe_active']    = trim($this->security->xss_clean(trim(html_escape($this->input->post('stripe_active')))));
        $stripe['testmode']         = trim($this->security->xss_clean(trim(html_escape($this->input->post('testmode')))));
        $stripe['secret_key']       = trim($this->security->xss_clean(trim(html_escape($this->input->post('secret_key')))));
        $stripe['public_key']       = trim($this->security->xss_clean(trim(html_escape($this->input->post('public_key')))));
        $stripe['secret_live_key']  = trim($this->security->xss_clean(trim(html_escape($this->input->post('secret_live_key')))));
        $stripe['public_live_key']  = trim($this->security->xss_clean(trim(html_escape($this->input->post('public_live_key')))));

        array_push($stripe_info, $stripe);

        $data['description'] = json_encode($stripe_info);
        $this->db->where('type', 'stripe_setting');
        $this->db->update('settings', $data);
    }

    function paypal_settings()
    {
        $paypal_info = array();

        $stripe['paypal_active']    = trim($this->security->xss_clean(trim(html_escape($this->input->post('paypal_active')))));
        $stripe['paypal_mode']         = trim($this->security->xss_clean(trim(html_escape($this->input->post('paypal_mode')))));
        $stripe['sandbox_client_id']       =trim($this->security->xss_clean(trim(html_escape($this->input->post('sandbox_client_id')))));
        $stripe['production_client_id']       = trim($this->security->xss_clean(trim(html_escape($this->input->post('production_client_id')))));

        array_push($paypal_info, $stripe);

        $data['description'] = json_encode($paypal_info);
        $this->db->where('type', 'paypal_setting');
        $this->db->update('settings', $data);
    }


    function send_student_score_model()
    {

        $exam_id = trim($this->security->xss_clean(trim($this->input->post('exam_id'))));
        $class_id =trim($this->security->xss_clean(trim($this->input->post('class_id'))));
        $receiver = trim($this->security->xss_clean(trim($this->input->post('receiver'))));

        $select_all_student_from_student_table = $this->db->get_where('student', array('class_id' => $class_id))->result_array();
        foreach ($select_all_student_from_student_table as $key => $all_selected_student_from_student_table) {

            if ($receiver == 'student')
                $recieverPhoneNumber = $all_selected_student_from_student_table['phone'];
            if ($receiver == 'parent' && $all_selected_student_from_student_table['parent_id'] != NULL)
                $select_from_parent_table = $this->db->get_where('parent', array('parent_id' => $all_selected_student_from_student_table['parent_id']))->row()->phone;

            $this->db->where('exam_id', $exam_id);
            $this->db->where('student_id', $all_selected_student_from_student_table['student_id']);
            $select_student_score_from_mark_table = $this->db->get('mark')->result_array();

            foreach ($select_student_score_from_mark_table as $key => $all_selected_student_scores_from_mark_table) {
                $message = '';

                $selelect_all_subject_from_subject_table = $this->db->get_where('subject', array('subject_id' => $all_selected_student_scores_from_mark_table['subject_id']))->row()->name;
                $student_mark_obtained_in_class_score_and_exam = $all_selected_student_scores_from_mark_table['class_score1'] + $all_selected_student_scores_from_mark_table['class_score2'] + $all_selected_student_scores_from_mark_table['class_score3'] + $all_selected_student_scores_from_mark_table['exam_score'];
                $message .= $all_selected_student_scores_from_mark_table['student_id'] . ' ' . $selelect_all_subject_from_subject_table . ':' . $student_mark_obtained_in_class_score_and_exam . 'Over 100';

                // Sending sms 
                $this->sms_model->send_sms($message, $recieverPhoneNumber);
            }
        }
    }



    function create_online_exam()
    {
        $class_id = $this->security->xss_clean($this->input->post('class_id'));

        $data['title'] = trim($this->security->xss_clean(trim($this->input->post('exam_title'))));
        $data['section_id'] = trim($this->security->xss_clean(trim($this->input->post('section_id'))));
        $data['subject_id'] = trim($this->security->xss_clean(trim($this->input->post('subject_id'))));
        $data['minimum_percentage'] = trim($this->security->xss_clean(trim($this->input->post('minimum_percentage'))));
        $data['instruction'] = trim($this->security->xss_clean(trim($this->input->post('instruction'))));
        $data['exam_date'] = strtotime(trim($this->security->xss_clean(trim($this->input->post('exam_date')))));
        $data['time_start'] = trim($this->security->xss_clean(trim($this->input->post('time_start'))));
        $data['status'] = 'pending';
        $data['time_end'] = trim($this->security->xss_clean(trim($this->input->post('time_end'))));
        $data['duration'] = strtotime(date('Y-m-d', $data['exam_date']) . ' ' . $data['time_end']) - strtotime(date('Y-m-d', $data['exam_date']) . ' ' . $data['time_start']);
        $data['running_year'] =   $this->db->get_where('settings', array('type' => 'session'))->row()->description;

        foreach ($class_id as $class) {
            
            $data['class_id'] = $class;
            $data['code']  = substr(md5(uniqid(rand(), true)), 0, 7);

            $this->db->insert('online_exam', $data);
        }
        

        return true;
        
    }

    function update_online_exam()
    {

        $data['title'] = $this->input->post('exam_title');
        $data['class_id'] = $this->input->post('class_id');
        $data['section_id'] = $this->input->post('section_id');
        $data['subject_id'] = $this->input->post('subject_id');
        $data['minimum_percentage'] = $this->input->post('minimum_percentage');
        $data['instruction'] = $this->input->post('instruction');
        $data['exam_date'] = strtotime($this->input->post('exam_date'));
        $data['time_start'] = $this->input->post('time_start');
        $data['time_end'] = $this->input->post('time_end');
        $data['duration'] = strtotime(date('Y-m-d', $data['exam_date']) . ' ' . $data['time_end']) - strtotime(date('Y-m-d', $data['exam_date']) . ' ' . $data['time_start']);

        $this->db->where('online_exam_id', $this->input->post('online_exam_id'));
        $this->db->update('online_exam', $data);
    }
    
    
    function sync_equivalent_online_exam($equivalent_online_exam_id,$arr_data)
    {
        $equivalent_online_exam_id_jsonString = $equivalent_online_exam_id[0]; 
        $equivalent_online_exam_idss = json_decode($equivalent_online_exam_id_jsonString, true);

        if (is_array($equivalent_online_exam_idss) && !empty($equivalent_online_exam_idss))
        {
            foreach ($equivalent_online_exam_idss as $eq_exam_id_online)
            { 
                $arr_data['online_exam_id'] = $eq_exam_id_online;
                $this->db->insert('question_bank', $arr_data);
            }
            
        }

        return true;
    }

    // multiple_choice_question crud functions
    function add_multiple_choice_question_to_online_exam($online_exam_id)
    {
        if (sizeof($this->input->post('options')) != $this->input->post('number_of_options')) {
            $this->session->set_flashdata('error_message', get_phrase('no_options_can_be_blank'));
            return;
        }
        foreach ($this->input->post('options') as $option) {
            if ($option == "") {
                $this->session->set_flashdata('error_message', get_phrase('no_options_can_be_blank'));
                return;
            }
        }
        
       /* 
        --------- Do Not Uncomment This , it will generate error and as a result you can't add multiple question ----------------
       if (sizeof($this->input->post('correct_answers')) == 0) {
            $correct_answers = [""];
        } else {
            $correct_answers = $this->input->post('correct_answers');
        }*/
        
       $correct_answers_input = $this->input->post('correct_answers');
        if (!isset($correct_answers_input) || !is_array($correct_answers_input) || sizeof($correct_answers_input) == 0) {
            $correct_answers = [""];
        } else {
            $correct_answers = $this->security->xss_clean($correct_answers_input);
        } 
        
        $data['online_exam_id']     = $online_exam_id;
        $data['question_title']     = $this->input->post('question_title');
        $data['mark']               = $this->input->post('mark');
        $data['number_of_options']  = $this->input->post('number_of_options');
        $data['type']               = 'multiple_choice';
        $data['options']            = json_encode($this->input->post('options'));
        $data['correct_answers']    = json_encode($correct_answers);
        $this->db->insert('question_bank', $data);
        
         /*-- Tag Equivalent Exam Class --*/ 
        $equivalent_online_exam_id = $this->security->xss_clean($this->input->post('equivalent_exam_class')); 
        $this->sync_equivalent_online_exam($equivalent_online_exam_id,$data);
        /*-- Tag Equivalent Exam Class --*/ 
        
        $this->session->set_flashdata('flash_message', get_phrase('question_added'));
    }

    function update_multiple_choice_question($question_id)
    {
        if (sizeof($this->input->post('options')) != $this->input->post('number_of_options')) {
            $this->session->set_flashdata('error_message', get_phrase('no_options_can_be_blank'));
            return;
        }
        foreach ($this->input->post('options') as $option) {
            if ($option == "") {
                $this->session->set_flashdata('error_message', get_phrase('no_options_can_be_blank'));
                return;
            }
        }

        if (sizeof($this->input->post('correct_answers')) == 0) {
            $correct_answers = [""];
        } else {
            $correct_answers = $this->input->post('correct_answers');
        }

        $data['question_title']     = $this->input->post('question_title');
        $data['mark']               = $this->input->post('mark');
        $data['number_of_options']  = $this->input->post('number_of_options');
        $data['options']            = json_encode($this->input->post('options'));
        $data['correct_answers']    = json_encode($correct_answers);
        $this->db->where('question_bank_id', $question_id);
        $this->db->update('question_bank', $data);
        $this->session->set_flashdata('flash_message', get_phrase('question_updated'));
    }

    // true false questions crud functions
    function add_true_false_question_to_online_exam($online_exam_id)
    {
        $data['online_exam_id']     = $online_exam_id;
        $data['question_title']     = $this->input->post('question_title');
        $data['type']               = 'true_false';
        $data['mark']               = $this->input->post('mark');
        $data['correct_answers']    = $this->input->post('true_false_answer');
        $this->db->insert('question_bank', $data);
        
         /*-- Tag Equivalent Exam Class --*/ 
        $equivalent_online_exam_id = $this->security->xss_clean($this->input->post('equivalent_exam_class')); 
        $this->sync_equivalent_online_exam($equivalent_online_exam_id,$data);
        /*-- Tag Equivalent Exam Class --*/ 
        
        $this->session->set_flashdata('flash_message', get_phrase('question_added'));
    }
    function update_true_false_question($question_id)
    {
        $data['question_title']     = $this->input->post('question_title');
        $data['mark']               = $this->input->post('mark');
        $data['correct_answers']    = $this->input->post('true_false_answer');

        $this->db->where('question_bank_id', $question_id);
        $this->db->update('question_bank', $data);
        $this->session->set_flashdata('flash_message', get_phrase('question_updated'));
    }

    // fill in the blanks question portion
    function add_fill_in_the_blanks_question_to_online_exam($online_exam_id)
    {
        $suitable_words_array = explode(',', $this->input->post('suitable_words'));
        $suitable_words = array();
        foreach ($suitable_words_array as $row) {
            array_push($suitable_words, strtolower($row));
        }
        $data['online_exam_id']     = $online_exam_id;
        $data['question_title']     = $this->input->post('question_title');
        $data['type']               = 'fill_in_the_blanks';
        $data['mark']               = $this->input->post('mark');
        $data['correct_answers']    = json_encode(array_map('trim', $suitable_words));
        $this->db->insert('question_bank', $data);
        
         /*-- Tag Equivalent Exam Class --*/ 
        $equivalent_online_exam_id = $this->security->xss_clean($this->input->post('equivalent_exam_class')); 
        $this->sync_equivalent_online_exam($equivalent_online_exam_id,$data);
        /*-- Tag Equivalent Exam Class --*/ 
        
        $this->session->set_flashdata('flash_message', get_phrase('question_added'));
    }
    function update_fill_in_the_blanks_question($question_id)
    {
        $suitable_words_array = explode(',', $this->input->post('suitable_words'));
        $suitable_words = array();
        foreach ($suitable_words_array as $row) {
            array_push($suitable_words, strtolower($row));
        }
        $data['question_title']     = $this->input->post('question_title');
        $data['mark']               = $this->input->post('mark');
        $data['correct_answers']    = json_encode(array_map('trim', $suitable_words));

        $this->db->where('question_bank_id', $question_id);
        $this->db->update('question_bank', $data);
        $this->session->set_flashdata('flash_message', get_phrase('question_updated'));
    }
    function delete_question_from_online_exam($question_id)
    {
        $this->db->where('question_bank_id', $question_id);
        $this->db->delete('question_bank');
    }
    function manage_online_exam_status($online_exam_id = "", $status = "")
    {
        $checker = array(
            'online_exam_id' => $online_exam_id
        );
        $updater = array(
            'status' => $status
        );

        $this->db->where($checker);
        $this->db->update('online_exam', $updater);
        $this->session->set_flashdata('flash_message', get_phrase('exam') . ' ' . $status);
    }

    function available_exams($student_id)
    {
        $running_year = get_settings('session');
        $class_id = $this->db->get_where('student', array('student_id' => $student_id))->row()->class_id;
        $section_id = $this->db->get_where('student', array('student_id' => $student_id))->row()->section_id;

        // 'section_id' => $section_id,
        $match = array('running_year' => $running_year, 'class_id' => $class_id,  'status' => 'published');
        $this->db->order_by("exam_date", "dsc");
        $exams = $this->db->where($match)->get('online_exam')->result_array();

        return $exams;
    }

    function change_online_exam_status_to_attended_for_student($online_exam_id = "")
    {

        $checker = array(
            'online_exam_id' => $online_exam_id,
            'student_id' => $this->session->userdata('login_user_id')
        );

        if ($this->db->get_where('online_exam_result', $checker)->num_rows() == 0) {
            $inserted_array = array(
                'status' => 'attended',
                'online_exam_id' => $online_exam_id,
                'student_id' => $this->session->userdata('login_user_id'),
                'exam_started_timestamp' => strtotime("now")
            );
            $this->db->insert('online_exam_result', $inserted_array);
        }
    }

    function submit_online_exam($online_exam_id = "", $answer_script = "")
    {

        $checker = array(
            'online_exam_id' => $online_exam_id,
            'student_id' => $this->session->userdata('login_user_id')
        );
        $updated_array = array(
            'status' => 'submitted',
            'answer_script' => $answer_script
        );

        $this->db->where($checker);
        $this->db->update('online_exam_result', $updated_array);

        $this->calculate_exam_mark($online_exam_id);
    }

    function calculate_exam_mark($online_exam_id)
    {

        $checker = array(
            'online_exam_id' => $online_exam_id,
            'student_id' => $this->session->userdata('login_user_id')
        );


        $obtained_marks = 0;
        $online_exam_result = $this->db->get_where('online_exam_result', $checker);
        if ($online_exam_result->num_rows() == 0) {

            $data['obtained_mark'] = 0;
        } else {
            $results = $online_exam_result->row_array();
            $answer_script = json_decode($results['answer_script'], true);
            foreach ($answer_script as $row) {

                if ($row['submitted_answer'] == $row['correct_answers']) {

                    $obtained_marks = $obtained_marks + $this->get_question_details_by_id($row['question_bank_id'], 'mark');
                }
            }
            $data['obtained_mark'] = $obtained_marks;
        }
        $total_mark = $this->get_total_mark($online_exam_id);
        $query = $this->db->get_where('online_exam', array('online_exam_id' => $online_exam_id))->row_array();
        $minimum_percentage = $query['minimum_percentage'];

        $minumum_required_marks = ($total_mark * $minimum_percentage) / 100;
        if ($minumum_required_marks > $obtained_marks) {
            $data['result'] = 'fail';
        } else {
            $data['result'] = 'pass';
        }
        $this->db->where($checker);
        $this->db->update('online_exam_result', $data);
    }

    function get_total_mark($online_exam_id)
    {
        $added_question_info = $this->db->get_where('question_bank', array('online_exam_id' => $online_exam_id))->result_array();
        $total_mark = 0;
        if (sizeof($added_question_info) > 0) {
            foreach ($added_question_info as $single_question) {
                $total_mark = $total_mark + $single_question['mark'];
            }
        }
        return $total_mark;
    }

    function get_question_details_by_id($question_bank_id, $column_name = "")
    {

        return $this->db->get_where('question_bank', array('question_bank_id' => $question_bank_id))->row()->$column_name;
    }

    function check_availability_for_student($online_exam_id)
    {

        $result = $this->db->get_where('online_exam_result', array('online_exam_id' => $online_exam_id, 'student_id' => $this->session->userdata('login_user_id')))->row_array();

        return $result['status'];
    }

    function get_correct_answer($question_bank_id = "")
    {

        $question_details = $this->db->get_where('question_bank', array('question_bank_id' => $question_bank_id))->row_array();
        return $question_details['correct_answers'];
    }

    function get_online_exam_result($student_id)
    {
        $match = array('student_id' => $student_id, 'status' => 'submitted');
        $exams = $this->db->where($match)->get('online_exam_result')->result_array();
        return $exams;
    }
    


    ////////private message//////
    function send_new_private_message()
    {

        $message = trim($this->security->xss_clean(trim($this->input->post('message'))));
        $timestamp = strtotime(date("Y-m-d H:i:s"));
        $sender_type = $this->session->userdata('login_type');
        if ($this->input->post('receiver') != "")
            if ($sender_type == 'admin') {
                foreach ($this->input->post('receiver') as $row) {
                    $data['receiver']  = $row;

                    $reciever = $row;

                    $sender = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');

                    //check if the thread between those 2 users exists, if not create new thread
                    $num1 = $this->db->get_where('message_thread', array('sender' => $sender, 'reciever' => $reciever))->num_rows();
                    $num2 = $this->db->get_where('message_thread', array('sender' => $reciever, 'reciever' => $sender))->num_rows();

                    //check if file is attached or not
                    if ($_FILES['attached_file_on_messaging']['name'] != "") {
                        $data_message['attached_file_name'] = $_FILES['attached_file_on_messaging']['name'];
                    }

                    if ($num1 == 0 && $num2 == 0) {
                        $message_thread_code = substr(md5(rand(100000000, 20000000000)), 0, 15);
                        $data_message_thread['message_thread_code'] = $message_thread_code;
                        $data_message_thread['sender'] = $sender;
                        $data_message_thread['reciever'] = $reciever;
                        $this->db->insert('message_thread', $data_message_thread);
                    }
                    if ($num1 > 0)
                        $message_thread_code = $this->db->get_where('message_thread', array('sender' => $sender, 'reciever' => $reciever))->row()->message_thread_code;
                    if ($num2 > 0)
                        $message_thread_code = $this->db->get_where('message_thread', array('sender' => $reciever, 'reciever' => $sender))->row()->message_thread_code;


                    $data_message['message_thread_code'] = $message_thread_code;
                    $data_message['message'] = $message;
                    $data_message['sender'] = $sender;
                    $data_message['timestamp'] = $timestamp;
                    $this->db->insert('message', $data_message);
                }
            } else {
                $data['receiver']  = trim($this->security->xss_clean(trim($this->input->post('receiver'))));

                $reciever = trim($this->security->xss_clean(trim($this->input->post('receiver'))));

                $sender = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');

                //check if the thread between those 2 users exists, if not create new thread
                $num1 = $this->db->get_where('message_thread', array('sender' => $sender, 'reciever' => $reciever))->num_rows();
                $num2 = $this->db->get_where('message_thread', array('sender' => $reciever, 'reciever' => $sender))->num_rows();

                if ($num1 == 0 && $num2 == 0) {
                    $message_thread_code = substr(md5(rand(100000000, 20000000000)), 0, 15);
                    $data_message_thread['message_thread_code'] = $message_thread_code;
                    $data_message_thread['sender'] = $sender;
                    $data_message_thread['reciever'] = $reciever;
                    $this->db->insert('message_thread', $data_message_thread);
                }
                if ($num1 > 0)
                    $message_thread_code = $this->db->get_where('message_thread', array('sender' => $sender, 'reciever' => $reciever))->row()->message_thread_code;
                if ($num2 > 0)
                    $message_thread_code = $this->db->get_where('message_thread', array('sender' => $reciever, 'reciever' => $sender))->row()->message_thread_code;


                $data_message['message_thread_code'] = $message_thread_code;
                $data_message['message'] = $message;
                $data_message['sender'] = $sender;
                $data_message['timestamp'] = $timestamp;
                $this->db->insert('message', $data_message);
            }
        // notify email to email reciever
        $this->email_model->notify_email('new_message_notification', $this->db->insert_id());

        return $message_thread_code;
    }

    function send_reply_message($message_thread_code)
    {
        $message = trim($this->security->xss_clean(trim($this->input->post('message'))));
        $timestamp = strtotime(date("Y-m-d H:i:s"));
        $sender = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');

        if ($_FILES['attached_file_on_messaging']['name'] != "") {
            $data_message['attached_file_name'] = $_FILES['attached_file_on_messaging']['name'];
        }

        $data_message['message_thread_code'] = $message_thread_code;
        $data_message['message'] = $message;
        $data_message['sender'] = $sender;
        $data_message['timestamp'] = $timestamp;
        $this->db->insert('message', $data_message);
        $message_id = $this->db->insert_id();

        // notify email to email reciever
        $this->email_model->notify_email('new_message_notification', $this->db->insert_id());
        echo json_encode($data_message);
    }

    function mark_thread_messages_read($message_thread_code)
    {
        // mark read only the oponnent messages of this thread, not currently logged in user's sent messages
        $current_user = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');
        $this->db->where('sender !=', $current_user);
        $this->db->where('message_thread_code', $message_thread_code);
        $this->db->update('message', array('read_status' => 1));
    }

    function count_unread_message_of_thread($message_thread_code)
    {
        $unread_message_counter = 0;
        $current_user = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');
        $messages = $this->db->get_where('message', array('message_thread_code' => $message_thread_code))->result_array();
        foreach ($messages as $row) {
            if ($row['sender'] != $current_user && $row['read_status'] == '0')
                $unread_message_counter++;
        }
        return $unread_message_counter;
    }

    function count_unread_message_of_curuser()
    {
        $current_user = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');
        $sql = "select count(a.message_id) counts from message a "
            . " inner join message_thread b on a.message_thread_code=b.message_thread_code "
            . " where b.reciever='" . $current_user . "' and a.read_status=0";
        $row = $this->db->query($sql)->row_array();
        return $row["counts"];
    }

    function unread_message_of_curuser()
    {
        $data = array();
        $current_user = $this->session->userdata('login_type') . '-' . $this->session->userdata('login_user_id');
        $sql = "select a.*  from message a "
            . " inner join message_thread b on a.message_thread_code=b.message_thread_code "
            . " where b.reciever='" . $current_user . "' and a.read_status=0";
        $rows = $this->db->query($sql)->result_array();
        foreach ($rows as $row) {
            $sender = explode('-', $row['sender']);
            $sender_type = $sender[0];
            $sender_id = $sender[1];

            $sql = "select name from " . $sender_type . " where " . $sender_type . "_id=" . $sender_id;
            $result = $this->db->query($sql)->row_array();
            $row["sender_name"] = $result["name"];

            $key = $row['sender'];
            $face_file = 'uploads/' . $sender_type . '_image/' . $sender_id . '.jpg';
            if (!file_exists($face_file)) {
                $face_file = 'uploads/default_avatar.jpg';
            }
            $row["face_file"] = base_url() . $face_file;

            //            $cur_time = date('Y-m-d H:i:s', time());
            //            $send_time =date('Y-m-d H:i:s', $row["timestamp"]);
            //            echo $cur_time;
            //            $diff = date_diff($cur_time, $send_time);
            $ago = '';
            $sec = time() - $row["timestamp"];
            $year = (int) ($sec / 31556926);
            $month = (int) ($sec / 2592000);
            $day = (int) ($sec / 86400);
            $hou = (int) ($sec / 3600);
            $min = (int) ($sec / 60);
            if ($year > 0) {
                $ago = $year . ' year(s)';
            } else if ($month > 0) {
                $ago = $month . ' month(s)';
            } else if ($day > 0) {
                $ago = $day . ' day(s)';
            } else if ($hou > 0) {
                $ago = $hou . ' hour(s)';
            } else if ($min > 0) {
                $ago = $min . ' minute(s)';
            } else {
                $ago = $sec . ' second(s)';
            }

            $row["ago"] = $ago;

            array_push($data, $row);
        }
        return $data;
    }
    
    
    function promote_student($student_promote_id,$promoted_session,$previous_academic_session,$class_id)
    {
    	$insert_data = array(
		    	'student_id'=>$student_promote_id,
			'class_id'=>$class_id,
			'session'=>$promoted_session,
			'previous_session'=>$previous_academic_session,
			'promoted_dt'=>date('Y-m-d H:i:s'),
			'promoted_by'=>$this->session->userdata('login_user_id'),
			'by_usertype'=>$this->session->userdata('login_type')
    			);
    			
    	$does_exists = $this->get_data_mysql("id","student_class_registration","student_id='".$student_promote_id."' AND class_id='".$class_id."' AND session='".$promoted_session."' AND previous_session='".$previous_academic_session."'",'','1');
    	
    	if(( !is_object($does_exists) || !is_array($does_exists)) && $does_exists == '')
    	{
    	
    		//promote student
    		$this->db->insert("student_class_registration",$insert_data);
    		
    		$last_insert_id = $this->db->insert_id();
    		
    		if($last_insert_id > 0)
    		{
    		
    		  // find previous class id
    		  
    		  $prev_classid = $this->get_data_mysql("class_id","student","student_id='".$student_promote_id."'",'','1');
    		  if(is_object($prev_classid))
    		  {
                        $prev_class_id = $prev_classid->class_id;
    		  	$prev_class_promotedSession_data = array("is_promoted"=>$promoted_session);
    		  	$prev_class_promotedSession_whr = array("student_id"=>$student_promote_id,"class_id"=>$prev_class_id,"session"=>$previous_academic_session);
    		  	
    		  	//Acknowledge Previous Class Session that it has got promotion
    		  	$this->db->update('student_class_registration',$prev_class_promotedSession_data,$prev_class_promotedSession_whr);
    		  	
    		  	if($this->db->affected_rows() >=0)
    		      	{
    		      		// promoted new class to student
		    		   $updata = array(
					    'class_id'=>$class_id,
					    'session'=>$promoted_session
					);

					$whrdata = array(
					    'student_id'=>$student_promote_id
					);
		    		   $this->db->update('student',$updata,$whrdata);
		    		   
		    		      if($this->db->affected_rows() >=0)
		    		      {
					  return 1;
				      }
				      else
				      {
					 return 0;
				      }
    		      	}
    		      	else
    		      	{
    		      	   return 0;
    		      	}
    		  }
    		  else
    		  {
    		      return 0;
    		  }
    		  
    		}
    		else
    		{
    		   return 0;
    		}
    	}
    	else
    	{
    	   return 0;
    	}
    }//promote student ends
    
    function get_equivalent_exam_class($online_exam_id)
    {
       $this->db->select('exam_online.*, c.name AS class_name, s.name AS section_name, sub.name AS subject_name')
                ->from("(SELECT oe2.* FROM online_exam oe1 JOIN online_exam oe2 ON oe1.subject_id = oe2.subject_id AND oe1.running_year = oe2.running_year AND oe1.title = oe2.title AND oe1.status = oe2.status WHERE oe1.online_exam_id = '$online_exam_id') AS exam_online")
                ->join('class c', 'exam_online.class_id = c.class_id', 'left')
                ->join('section s', 'exam_online.section_id = s.section_id AND exam_online.class_id = s.class_id', 'left')
                ->join('subject sub', 'exam_online.subject_id = sub.subject_id', 'left');

        $query = $this->db->get();
        $result = $query->result();

        return $result;
    }
    
}
