<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


if (!function_exists('manager')) {
  function manager($total_rows, $per_page_item)
  {
    $config['per_page']        = $per_page_item;
    $config['num_links']       = 2;
    $config['total_rows']      = $total_rows;
    $config['full_tag_open']   = '<ul class="pagination justify-content-end">';
    $config['full_tag_close']  = '</ul>';
    $config['prev_link']       = '<span class="page-link">Previous</span>';
    $config['prev_tag_open']   = '<li class="page-item">';
    $config['prev_tag_close']  = '</li>';
    $config['next_link']       = '<span class="page-link">Next</span>';
    $config['next_tag_open']   = '<li class="page-item">';
    $config['next_tag_close']  = '</li>';
    $config['cur_tag_open']    = '<li class="page-item active"><span class="page-link">';
    $config['cur_tag_close']   = '<span class="sr-only">(current)</span></span></li>';
    $config['num_tag_open']    = '<li class="page-item"><span class="page-link">';
    $config['num_tag_close']   = '</span></li>';
    // $config['first_tag_open']  = '<span class="page-link">';
    // $config['first_tag_close'] = '</span>';
    // $config['last_tag_open']   = '<span class="page-link">';
    // $config['last_tag_close']  = '</span>';
    // $config['first_link']      = 'First';
    // $config['last_link']       = 'Last';
    $config['first_link'] = false;
    $config['last_link'] = false;
    return $config;
  }
}
if (!function_exists('get_settings')) {

  function get_settings($type)
  {

    $CI = get_instance();
    $CI->load->database();
    $des = $CI->db->get_where('settings', array('type' => $type))->row()->description;

    return $des;
  }
}


// Code by ab siddique 
if (!function_exists('session_checker')) {

  function session_checker($find_session, $value, $echo_result = "0")
  {
    $current_session = get_settings('session');

    if ($current_session == $find_session) {
      return $value;
    } else {
      return $echo_result;
    }
  }
}
if (!function_exists('x_debug')) {

  function x_debug($data)
  {
    echo "<pre>";
    print_r($data);
    echo "</pre>";
    exit;
  }
  function x_print($data)
  {
    echo "<pre>";
    print_r($data);
    echo "</pre>";
  }
}
if (!function_exists('getGradeComment')) {
  function getGradeComment($total_score)
  {
    if ($total_score >= 0.99 && $total_score <= 29.99) {
      return 'Fail';
    } elseif ($total_score >= 30 && $total_score <= 39.99) {
      return 'Weak Pass';
    } elseif ($total_score >= 40 && $total_score <= 44.99) {
      return 'Pass';
    } elseif ($total_score >= 45 && $total_score <= 69.99) {
      return 'Credit';
    } elseif ($total_score >= 70 && $total_score <= 79.99) {
      return 'Good';
    } elseif ($total_score >= 80 && $total_score <= 89.99) {
      return 'Very Good';
    } elseif ($total_score >= 90 && $total_score <= 100) {
      return 'Excellent';
    } else {
      return 'Absent'; // You can customize this for handling out-of-range scores
    }
  }
}

if (!function_exists('getGrade')) {
function getGrade($total_score) {
  if ($total_score >= 90) {
      return 'A1';
  } elseif ($total_score >= 79.99) {
      return 'B2';
  } elseif ($total_score >= 69.99) {
      return 'B3';
  } elseif ($total_score >= 59.99) {
      return 'C4';
  } elseif ($total_score >= 49.99) {
      return 'C5';
  } elseif ($total_score >= 44.99) {
      return 'C6';
  } elseif ($total_score >= 39.99) {
      return 'D7';
  } elseif ($total_score >= 29.99) {
      return 'E8';
  } elseif ($total_score >= 1) {
      return 'F9';
  } else {
      return 'AB';
  }
}
}