<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Teacher extends CI_Controller { 

    function __construct() {
        parent::__construct();
        		$this->load->database();                                //Load Databse Class
                $this->load->library('session');					    //Load library for session
                $this->load->helper('security');
                $this->load->model('Crud_model');                    // Loading the Barcode Model
               // $this->load->model('vacancy_model');

    }


    function get_running_session()
    {
        $data_active_session = $this->Crud_model->get_data_mysql("description","settings","type ='session'",'',1);

         return $data_active_session->description;
    }

     
    function get_promoted_session()
    {
        $data_promot_session = $this->Crud_model->get_data_mysql("description","settings","type ='promoted_session'",'',1);

         return $data_promot_session->description;
    }

     /*teacher dashboard code to redirect to teacher page if successfull login** */
     function dashboard() {
        if ($this->session->userdata('teacher_login') != 1) redirect(base_url(), 'refresh');
       	$page_data['page_name'] = 'dashboard';
        $page_data['page_title'] = get_phrase('Teacher Dashboard');
        $this->load->view('backend/index', $page_data);
    }
	/******************* / teacher dashboard code to redirect to teacher page if successfull login** */

    function manage_profile($param1 = null, $param2 = null, $param3 = null){
        if ($this->session->userdata('teacher_login') != 1) redirect(base_url(), 'refresh');
        if ($param1 == 'update') {
    
    
            $data['name']   =   trim($this->security->xss_clean(trim($this->input->post('name'))));
            $data['email']  =   trim($this->security->xss_clean(trim($this->input->post('email'))));
    
            $this->db->where('teacher_id', trim($this->security->xss_clean(trim($this->session->userdata('teacher_id')))));
            $this->db->update('teacher', $data);
            move_uploaded_file($_FILES['userfile']['tmp_name'], 'uploads/teacher_image/' . trim($this->security->xss_clean(trim($this->session->userdata('teacher_id')))) . '.jpg');
            $this->session->set_flashdata('flash_message', get_phrase('Info Updated'));
            redirect(base_url() . 'teacher/manage_profile', 'refresh');
           
        }
    
        if ($param1 == 'change_password') {
            $data['new_password']           =   sha1(trim($this->security->xss_clean(trim($this->input->post('new_password')))));
            $data['confirm_new_password']   =   sha1(trim($this->security->xss_clean(trim($this->input->post('confirm_new_password')))));
    
            if ($data['new_password'] == $data['confirm_new_password']) {
               
               $this->db->where('teacher_id', trim($this->security->xss_clean(trim($this->session->userdata('teacher_id')))));
               $this->db->update('teacher', array('password' => $data['new_password']));
               $this->session->set_flashdata('flash_message', get_phrase('Password Changed'));
            }
    
            else{
                $this->session->set_flashdata('error_message', get_phrase('Type the same password'));
            }
            redirect(base_url() . 'teacher/manage_profile', 'refresh');
        }
    
            $page_data['page_name']     = 'manage_profile';
            $page_data['page_title']    = get_phrase('Manage Profile');
            $page_data['edit_profile']  = $this->db->get_where('teacher', array('teacher_id' => trim($this->security->xss_clean(trim($this->session->userdata('teacher_id'))))))->result_array();
            $this->load->view('backend/index', $page_data);
        }



        function manage_attendance($date = null, $month= null, $year = null, $class_id = null, $section_id = null ){
            $active_sms_gateway = $this->db->get_where('sms_settings', array('type' => 'active_sms_gateway'))->row()->info;
            
            if ($_POST) {
                $statusArray = explode(',', trim($this->security->xss_clean(trim($this->input->post('status_values')))));
                $class_id = trim($this->security->xss_clean(trim($class_id)));
                // Loop all the students of $class_id
                $students = $this->db->get_where('student', array('class_id' => $class_id))->result_array();
                foreach ($students as $key => $student) {
                // $attendance_status = $this->input->post('status_' . $student['student_id']);


                $attendance_status = $statusArray[$key];

                $attendance_session = $this->db->get_where('settings', array('type' => 'session'))->row()->description;

                $year = trim($this->security->xss_clean(trim($year)));
                $month = trim($this->security->xss_clean(trim($month)));
                $date = trim($this->security->xss_clean(trim($date)));
                $section_id = trim($this->security->xss_clean(trim($section_id)));

                $full_date = $year . "-" . $month . "-" . $date;
                $this->db->where('student_id', $student['student_id']);
                $this->db->where('date', $full_date);
        


                $section_id_ab = trim($this->security->xss_clean(trim($this->input->post('section_id_ab'))));
                $this->db->where('section', $section_id_ab);

                // $this->db->update('attendance', array('status' => $attendance_status));
                $this->db->update('attendance', array('status' => $attendance_status, 'session' => $attendance_session, 'section' => $section_id_ab));
        
                       if ($attendance_status == 2) 
                {
                         if ($active_sms_gateway != '' || $active_sms_gateway != 'disabled') {
                            $student_name   = $this->db->get_where('student' , array('student_id' => $student['student_id']))->row()->name;
                            $parent_id      = $this->db->get_where('student' , array('student_id' => $student['student_id']))->row()->parent_id;
                            $message        = 'Your child' . ' ' . $student_name . 'is absent today.';
                            if($parent_id != null && $parent_id != 0){
                                $recieverPhoneNumber = $this->db->get_where('parent' , array('parent_id' => $parent_id))->row()->phone;
                                if($recieverPhoneNumber != '' || $recieverPhoneNumber != null){
                                    $this->sms_model->send_sms($message, $recieverPhoneNumber);
                                }
                                else{
                                    $this->session->set_flashdata('error_message' , get_phrase('Parent Phone Not Found'));
                                }
                            }
                            else{
                                $this->session->set_flashdata('error_message' , get_phrase('SMS Gateway Not Found'));
                            }
                        }
               }
            }
        
                $this->session->set_flashdata('flash_message', get_phrase('Updated Successfully'));
                redirect(base_url() . 'teacher/manage_attendance/' . $date . '/' . $month . '/' . $year . '/' . $class_id . '/' . $section_id, 'refresh');
            }
    
            $page_data['date'] = $date;
            $page_data['month'] = $month;
            $page_data['year'] = $year;
            $page_data['class_id'] = $class_id;
            $page_data['section_id'] = $section_id;
            $page_data['page_name'] = 'manage_attendance';
            $page_data['page_title'] = get_phrase('Manage Attendance');
            $this->load->view('backend/index', $page_data);
    
        }
    
        function attendance_selector(){
            $date = trim($this->security->xss_clean(trim($this->input->post('timestamp'))));
            $date = date_create($date);
            $date = date_format($date, "d/m/Y");
            $this->session->set_userdata("section_id", trim($this->security->xss_clean(trim($this->input->post('section_id')))));
            redirect(base_url(). 'teacher/manage_attendance/' .$date. '/' . trim($this->security->xss_clean(trim($this->input->post('class_id')))). '/' . trim($this->security->xss_clean(trim($this->input->post('section_id')))), 'refresh');
        }
    
    
        function attendance_report($class_id = NULL, $section_id = NULL, $month = NULL, $year = NULL) {
            
            $active_sms_gateway = $this->db->get_where('sms_settings', array('type' => 'active_sms_gateway'))->row()->info;

            $year = trim($this->security->xss_clean(trim($year)));
            $month = trim($this->security->xss_clean(trim($month)));
            $section_id = trim($this->security->xss_clean(trim($section_id)));
            $class_id = trim($this->security->xss_clean(trim($class_id)));
            
            
            if ($_POST) {
            redirect(base_url() . 'teacher/attendance_report/' . $class_id . '/' . $section_id . '/' . $month . '/' . $year, 'refresh');
            }
            
            $classes = $this->db->get('class')->result_array();
            foreach ($classes as $key => $class) {
                if (isset($class_id) && $class_id == $class['class_id'])
                    $class_name = $class['name'];
                }
                        
            $sections = $this->db->get('section')->result_array();
                foreach ($sections as $key => $section) {
                    if (isset($section_id) && $section_id == $section['section_id'])
                        $section_name = $section['name'];
            }
            
            $page_data['month'] = $month;
            $page_data['year'] = $year;
            $page_data['class_id'] = $class_id;
            $page_data['section_id'] = $section_id;
            $page_data['page_name'] = 'attendance_report';
            $page_data['page_title'] = "Attendance Report:" . $class_name . " : Section " . $section_name;
            $this->load->view('backend/index', $page_data);
        }
    
    
        /******************** Load attendance with ajax code starts from here **********************/
        function loadAttendanceReport($class_id, $section_id, $month, $year)
        {
            $year = trim($this->security->xss_clean(trim($year)));
            $month = trim($this->security->xss_clean(trim($month)));
            $section_id = trim($this->security->xss_clean(trim($section_id)));
            $class_id = trim($this->security->xss_clean(trim($class_id)));

            $page_data['class_id'] 		= $class_id;					// get all class_id
            $page_data['section_id'] 	= $section_id;					// get all section_id
            $page_data['month'] 		= $month;						// get all month
            $page_data['year'] 			= $year;						// get all class year
            
            $this->load->view('backend/teacher/loadAttendanceReport' , $page_data);
        }
        /******************** Load attendance with ajax code ends from here **********************/
        
    
        /******************** print attendance report **********************/
        function printAttendanceReport($class_id=NULL, $section_id=NULL, $month=NULL, $year=NULL)
        {
            $year = trim($this->security->xss_clean(trim($year)));
            $month = trim($this->security->xss_clean(trim($month)));
            $section_id = trim($this->security->xss_clean(trim($section_id)));
            $class_id = trim($this->security->xss_clean(trim($class_id)));
            
            $page_data['class_id'] 		= $class_id;					// get all class_id
            $page_data['section_id'] 	= $section_id;					// get all section_id
            $page_data['month'] 		= $month;						// get all month
            $page_data['year'] 			= $year;						// get all class year
            
            $page_data['page_name'] = 'printAttendanceReport';
            $page_data['page_title'] = "Attendance Report";
            $this->load->view('backend/index', $page_data);
        }
        /******************** /Ends here **********************/
     /***********  The function below manages school marks ***********************/
     function marks ($exam_id = null, $class_id = null, $student_id = null){

        if($this->session->userdata('login_user_id'))
        {
            $running_session= $this->get_running_session();
            $teachers_identity = $this->session->userdata('login_user_id');

            if($this->input->post('operation') == 'selection'){

                $page_data['exam_id']       =  trim($this->security->xss_clean(trim($this->input->post('exam_id')))); 
                $page_data['class_id']      =  trim($this->security->xss_clean(trim($this->input->post('class_id'))));
                $page_data['student_id']    =  trim($this->security->xss_clean(trim($this->input->post('student_id'))));
                $page_data['running_session']=  $running_session;
                $page_data['teachers_identity'] = $teachers_identity;
    
                if($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['student_id'] > 0){
    
                    redirect(base_url(). 'teacher/marks/'. $page_data['exam_id'] .'/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
                }
                else{
                    $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));
                    redirect(base_url(). 'teacher/marks', 'refresh');
                }
            }
    
            if($this->input->post('operation') == 'update_student_subject_score'){
    
                $select_subject_first = $this->db->get_where('subject', array('class_id' => trim($this->security->xss_clean(trim($class_id))) ))->result_array();
                    foreach ($select_subject_first as $key => $dispay_subject_from_subject_table){
    
                        $page_data['class_score1']  =   trim($this->security->xss_clean(trim($this->input->post('class_score1_' . $dispay_subject_from_subject_table['subject_id']))));
                        $page_data['class_score2']  =   trim($this->security->xss_clean(trim($this->input->post('class_score2_' . $dispay_subject_from_subject_table['subject_id']))));
                        $page_data['class_score3']  =   trim($this->security->xss_clean(trim($this->input->post('class_score3_' . $dispay_subject_from_subject_table['subject_id']))));
                        $page_data['exam_score']    =   trim($this->security->xss_clean(trim($this->input->post('exam_score_' . $dispay_subject_from_subject_table['subject_id']))));
                        $page_data['comment']       =   trim($this->security->xss_clean(trim($this->input->post('comment_' . $dispay_subject_from_subject_table['subject_id']))));
                        
                        $this->db->where('mark_id', $this->input->post('mark_id_' . $dispay_subject_from_subject_table['subject_id']));
                        $this->db->update('mark', $page_data);  
                    }
                
                    $this->session->set_flashdata('flash_message', get_phrase('Data Updated Successfully'));
                    redirect(base_url(). 'teacher/marks/'. trim($this->security->xss_clean(trim($this->input->post('exam_id')))) .'/' . trim($this->security->xss_clean(trim($this->input->post('class_id')))) . '/' . trim($this->security->xss_clean(trim($this->input->post('student_id')))), 'refresh');
            }
    
            $page_data['exam_id']       =   trim($this->security->xss_clean(trim($exam_id)));
            $page_data['class_id']      =   trim($this->security->xss_clean(trim($class_id)));
            $page_data['student_id']    =   trim($this->security->xss_clean(trim($student_id)));
            $page_data['subject_id']   =    $subject_id;
            $page_data['page_name']     =   'marks';
            $page_data['running_session']=  $running_session;
            $page_data['teachers_identity'] = $teachers_identity;
            $page_data['page_title']    = get_phrase('Student Marks');
            $this->load->view('backend/index', $page_data);
        }//active session
        else
        {
            redirect(base_url(), 'refresh');
        }
        
        
    }
    /***********  The function that manages school marks ends here ***********************/

    /***********  The function that manages mid term starts here ***********************/
    function tabulation_sheet_mid($exam_id = null, $class_id = null, $student_id = null){

        if($this->session->userdata('login_user_id'))
        {
            $teachers_identity = $this->session->userdata('login_user_id');

                if($this->input->post('operation') == 'selection'){

                    $page_data['exam_id']       =  trim($this->security->xss_clean(trim($this->input->post('exam_id')))); 
                    $page_data['class_id']      =  trim($this->security->xss_clean(trim($this->input->post('class_id'))));
                    $page_data['student_id']    =  trim($this->security->xss_clean(trim($this->input->post('student_id'))));
        
                    if($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['student_id'] > 0){
        
                        redirect(base_url(). 'teacher/tabulation_sheet_mid/'. $page_data['exam_id'] .'/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
                    }
                    else{
                        $this->session->set_flashdata('error_message', get_phrase('Please select something'));
                        redirect(base_url(). 'teacher/tabulation_sheet_mid', 'refresh');
                    }
                }
                 
                $page_data['exam_id']       =   trim($this->security->xss_clean(trim($exam_id)));
                $page_data['class_id']      =   trim($this->security->xss_clean(trim($class_id)));
                $page_data['student_id']    =   trim($this->security->xss_clean(trim($student_id)));
                $page_data['active_session']= $this->get_running_session();
                $page_data['teachers_identity'] = $teachers_identity;
                $page_data['page_name']     =   'tabulation_sheet_mid';
                $page_data['page_title']    = get_phrase('Student Marks');
                $this->load->view('backend/index', $page_data);
        }
        else
        {
            redirect(base_url(), 'refresh');
        }
    }

    function print_mass_report_card_mid($class_id, $exam_id)
    {
        if($this->session->userdata('login_user_id'))
        {
            $data['exam_id'] = $exam_id;
            $data['class_id'] = $class_id;
            $data['page_name'] = 'print_mass_report_card_mid_mod_by_ab';
            $data['page_title'] = get_phrase('Terminal Report');
            $data['exam_name'] = $this->db->get_where('exam', array('exam_id' => $exam_id))->row()->name;
            $data['page_title'] = get_phrase('Terminal Report');
            $data['data_classes'] = $this->Crud_model->get_classes_by_ab();
            //$data['number_in_class'] = $this->db->get_where('student', array('class_id' => $class_id))->num_rows();


            $running_session = $this->get_running_session();
            $data['active_session']= $running_session;
            $data['promoted_session']= $this->get_promoted_session();


            //$result = $this->Crud_model->total_sql_query($class_id, $exam_id);
            $result = $this->Crud_model->total_sql_query($class_id, $exam_id,$running_session);
            $data['class_name'] = $this->db->get_where('class', array('class_id' => $class_id))->row()->name;
            $data['number_in_class'] = $this->db->get_where('student_class_registration', array('class_id' => $class_id,'session'=>$running_session))->num_rows();

            // x_print($result);
            if ($result) {
                // Create an array to store the data
                $all_data = [];
                // Process the result data and structure it as needed
                foreach ($result as $row) {
                    $student_id = $row->student_id;
                    $subject_name = $row->subject_name;
                    $ispromoted = $row->is_promoted;
                    
                    if ($exam_id == 1) {
                        $class_score1 = $row->first_term_class_score1;
                        $class_score2 = $row->first_term_class_score2;
                        $class_score3 = $row->first_term_class_score3;
                        $exam_score = $row->first_term_exam_score;
                        $subject_remark = $row->comment;
                    } elseif ($exam_id == 3) {
                        $class_score1 = $row->second_term_class_score1;
                        $class_score2 = $row->second_term_class_score2;
                        $class_score3 = $row->second_term_class_score3;
                        $exam_score = $row->second_term_exam_score;
                        $subject_remark = $row->comment;
                    } elseif ($exam_id == 4) {
                        $class_score1 = $row->third_term_class_score1;
                        $class_score2 = $row->third_term_class_score2;
                        $class_score3 = $row->third_term_class_score3;
                        $exam_score = $row->third_term_exam_score;
                        $subject_remark = $row->comment;
                    }

                    $exam_score = $exam_score;

                    // Initialize the student data if it doesn't exist
                    if (!isset($all_data[$student_id])) {

                        $student_array = [
                            'name' => $row->student_name,
                            'sex' => $row->sex,
                            'teachercomment' => $row->teachercomment,
                            'teachercomment_id' => $row->teachercomment_id,
                            'is_promoted'=>$ispromoted,
                        ];


                        $all_data[$student_id] = [
                            'student_info' => $student_array,
                            'mark' => []
                        ];
                    }


                    $subject_array = [
                        'class_score1' => $class_score1,
                        'class_score2' =>  $class_score2,
                        'class_score3' =>  $class_score3,
                        'exam_score' =>   $exam_score,
                        'first_term_class_score1' => $row->first_term_class_score1,
                        'first_term_class_score2' => $row->first_term_class_score2,
                        'first_term_class_score3' => $row->first_term_class_score3,
                        'first_term_exam_score' => $row->first_term_exam_score,
                        'second_term_class_score1' => $row->second_term_class_score1,
                        'second_term_class_score2' => $row->second_term_class_score2,
                        'second_term_class_score3' => $row->second_term_class_score3,
                        'second_term_exam_score' => $row->second_term_exam_score,
                        'third_term_class_score1' => $row->third_term_class_score1,
                        'third_term_class_score2' => $row->third_term_class_score2,
                        'third_term_class_score3' => $row->third_term_class_score3,
                        'third_term_exam_score' => $row->third_term_exam_score,
                        'subject_remark' => $subject_remark,
                    ];

                    $all_data[$student_id]['mark'][$subject_name] = $subject_array;
                }

                // Now $all_data contains the required data in the desired format
                // x_print($all_data);
            } else {
                $all_data = FALSE;
            }

            $data['select_student_from_model'] = $all_data;


            // $this->output->enable_profiler(TRUE);

            // x_print($data['select_student_from_model']);
        
           $this->load->view('backend/index_mod_ab_last', $data);
        }//session active
        else
        {
            redirect(base_url(), 'refresh');
        }
    }
    /***********  The function that manages mid term starts here ***********************/

    /***********  The function below manages school marks ***********************/

    function tabulation_sheet($exam_id = null, $class_id = null, $student_id = null)
    {
        if($this->session->userdata('login_user_id'))
        {
            $teachers_identity = $this->session->userdata('login_user_id');
            $page_data['current_session']    = $this->get_running_session();

            if ($this->input->post('operation') == 'selection') {

                $page_data['exam_id']       =  $this->input->post('exam_id');

                $page_data['class_id']      =  $this->input->post('class_id');

                $page_data['student_id']    =  $this->input->post('student_id');

                $page_data['active_session'] = $this->get_running_session();


                if ($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['student_id'] > 0) {

                    redirect(base_url() . 'teacher/tabulation_sheet/' . $page_data['exam_id'] . '/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
                } else {

                    $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));

                    redirect(base_url() . 'teacher/tabulation_sheet', 'refresh');
                }
            }

            $page_data['exam_id']       =   $exam_id;

            $page_data['class_id']      =   $class_id;

            $page_data['student_id']    =   $student_id;

            // $page_data['subject_id']   =    $subject_id;
            $page_data['active_session']= $this->get_running_session();
            $page_data['teachers_identity'] = $teachers_identity;

            $page_data['page_name']     =   'tabulation_sheet';

            $page_data['page_title']    = get_phrase('Student Marks');


            $this->load->view('backend/index', $page_data);
        }//session active
        else
        {
            redirect(base_url(), 'refresh');
        }

        // print_r(get_settings('session'));
        // exit();
        
    }

    function print_mass_report_card($class_id, $exam_id)
    {
        $data['exam_id'] = $exam_id;
        $data['class_id'] = $class_id;
        $data['page_name'] = 'print_mass_report_card_mod_by_ab';
        $data['page_title'] = get_phrase('Terminal Report');
        $data['exam_name'] = $this->db->get_where('exam', array('exam_id' => $exam_id))->row()->name;
        $data['page_title'] = get_phrase('Terminal Report');
        $data['data_classes'] = $this->Crud_model->get_classes_by_ab();

        $running_session = $this->get_running_session();
        $data['active_session']= $running_session;
        $data['promoted_session']= $this->get_promoted_session();

        //$result = $this->Crud_model->total_sql_query($class_id, $exam_id);
        $result = $this->Crud_model->total_sql_query($class_id, $exam_id,$running_session);
        $data['class_name'] = $this->db->get_where('class', array('class_id' => $class_id))->row()->name;
        //$data['number_in_class'] = $this->db->get_where('student', array('class_id' => $class_id))->num_rows();
        $data['number_in_class'] = $this->db->get_where('student_class_registration', array('class_id' => $class_id,'session'=>$running_session))->num_rows();

        // echo "<pre>";
        // print_r($result);
        // exit;
        // x_print($result);
        if ($result) {
            // Create an array to store the data
            $all_data = [];




            // Process the result data and structure it as needed
            foreach ($result as $row) {
                $student_id = $row->student_id;
                $subject_name = $row->subject_name;
                $ispromoted = $row->is_promoted;



                if ($exam_id == 1) {
                    $class_score1 = $row->first_term_class_score1;
                    $class_score2 = $row->first_term_class_score2;
                    $class_score3 = $row->first_term_class_score3;
                    $exam_score = $row->first_term_exam_score;
                    $subject_remark = $row->comment;
                } elseif ($exam_id == 3) {
                    $class_score1 = $row->second_term_class_score1;
                    $class_score2 = $row->second_term_class_score2;
                    $class_score3 = $row->second_term_class_score3;
                    $exam_score = $row->second_term_exam_score;
                    $subject_remark = $row->comment;
                } elseif ($exam_id == 4) {
                    $class_score1 = $row->third_term_class_score1;
                    $class_score2 = $row->third_term_class_score2;
                    $class_score3 = $row->third_term_class_score3;
                    $exam_score = $row->third_term_exam_score;
                    $subject_remark = $row->comment;
                }


                // $subject_remark = $row->comment;


                $class_score_one    = $class_score1;
                $class_score_two    = $class_score2;
                $exam_score         = $exam_score;

                $total_score        = $class_score_one + $class_score_two + $exam_score;
                $average_score      = $total_score / 3;


                $class_score_one_first_term    = $row->first_term_class_score1;
                $class_score_two_first_term    = $row->first_term_class_score2;
                $class_score_three_first_term  = $row->first_term_class_score3;
                $exam_score_first_term         = $row->first_term_exam_score;


                $total_score_first_term        = $class_score_one_first_term + $class_score_two_first_term + $exam_score_first_term;
                $average_score_first_term      = $total_score_first_term / 3;




                $class_score_one_second_term    = $row->second_term_class_score1;
                $class_score_two_second_term    = $row->second_term_class_score2;
                $class_score_three_second_term  =  $row->second_term_class_score3;
                $exam_score_second_term         = $row->second_term_exam_score;


                $total_score_second_term        = $class_score_one_second_term + $class_score_two_second_term + $exam_score_second_term;
                $average_score_second_term      = $total_score_second_term / 3;
                $overall_average_score_second_term = ($total_score + $total_score_first_term) / 2;


                $overall_average_score = ($total_score + $total_score_first_term + $total_score_second_term) / 3;


                // Initialize the student data if it doesn't exist
                if (!isset($all_data[$student_id])) {

                    $student_array = [
                        'name' => $row->student_name,
                        'sex' => $row->sex,
                        'teachercomment' => $row->teachercomment,
                        'teachercomment_id' => $row->teachercomment_id,
                        'is_promoted'=>$ispromoted,
                    ];


                    $all_data[$student_id] = [
                        'student_info' => $student_array,
                        'mark' => []
                    ];
                }


                $subject_array = [
                    'class_score1' => $class_score1,
                    'class_score2' =>  $class_score2,
                    'class_score3' =>  $class_score3,
                    'exam_score' =>   $exam_score,
                    'first_term_class_score1' => $row->first_term_class_score1,
                    'first_term_class_score2' => $row->first_term_class_score2,
                    'first_term_class_score3' => $row->first_term_class_score3,
                    'first_term_exam_score' => $row->first_term_exam_score,
                    'second_term_class_score1' => $row->second_term_class_score1,
                    'second_term_class_score2' => $row->second_term_class_score2,
                    'second_term_class_score3' => $row->second_term_class_score3,
                    'second_term_exam_score' => $row->second_term_exam_score,
                    'third_term_class_score1' => $row->third_term_class_score1,
                    'third_term_class_score2' => $row->third_term_class_score2,
                    'third_term_class_score3' => $row->third_term_class_score3,
                    'third_term_exam_score' => $row->third_term_exam_score,
                    'subject_remark' => $subject_remark,
                ];

                $all_data[$student_id]['mark'][$subject_name] = $subject_array;
            }

            // Now $all_data contains the required data in the desired format
            // x_print($all_data);
        } else {
            $all_data = FALSE;
        }

        $data['select_student_from_model'] = $all_data;


        // $this->output->enable_profiler(TRUE);

        // x_print($data['select_student_from_model']);
        $this->load->view('backend/index_mod_ab_last', $data);
    }

    /***********  The function below manages school marks ***********************/
    function student_marksheet_subject ($exam_id = null, $class_id = null, $subject_id = null){

        if($this->session->userdata('login_user_id'))
        {
            $running_session= $this->get_running_session();
            $teachers_identity = $this->session->userdata('login_user_id');

            if($this->input->post('operation') == 'selection'){

                $page_data['exam_id']       =  trim($this->security->xss_clean(trim($this->input->post('exam_id')))); 
                $page_data['class_id']      =  trim($this->security->xss_clean(trim($this->input->post('class_id'))));
                $page_data['subject_id']    =  trim($this->security->xss_clean(trim($this->input->post('subject_id'))));
                $page_data['running_session']=  $running_session;
                $page_data['teachers_identity'] = $teachers_identity;
        
                if($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['subject_id'] > 0){
        
                    redirect(base_url(). 'teacher/student_marksheet_subject/'. $page_data['exam_id'] .'/' . $page_data['class_id'] . '/' . $page_data['subject_id'], 'refresh');
                }
                else{
                    $this->session->set_flashdata('error_message', get_phrase('Please select something'));
                    redirect(base_url(). 'teacher/student_marksheet_subject', 'refresh');
                }
            }
        
            if($this->input->post('operation') == 'update_student_subject_score'){
        
                $select_student_first = $this->db->get_where('student', array('class_id' => trim($this->security->xss_clean(trim($class_id))) ))->result_array();
                    foreach ($select_student_first as $key => $dispay_student_from_student_table){
        
                        $page_data['class_score1']  =   trim($this->security->xss_clean(trim($this->input->post('class_score1_' . $dispay_student_from_student_table['student_id']))));
                        $page_data['class_score2']  =   trim($this->security->xss_clean(trim($this->input->post('class_score2_' . $dispay_student_from_student_table['student_id']))));
                        $page_data['class_score3']  =   trim($this->security->xss_clean(trim($this->input->post('class_score3_' . $dispay_student_from_student_table['student_id']))));
                        $page_data['exam_score']    =   trim($this->security->xss_clean(trim($this->input->post('exam_score_' . $dispay_student_from_student_table['student_id']))));
                        $page_data['comment']       =   trim($this->security->xss_clean(trim($this->input->post('comment_' . $dispay_student_from_student_table['student_id']))));
        
                        $this->db->where('mark_id', $this->input->post('mark_id_' . $dispay_student_from_student_table['student_id']));
                        $this->db->update('mark', $page_data);  
                    }
        
                    $this->session->set_flashdata('flash_message', get_phrase('Data Updated Successfully'));
                    redirect(base_url(). 'teacher/student_marksheet_subject/'. $this->input->post('exam_id') .'/' . $this->input->post('class_id') . '/' . $this->input->post('subject_id'), 'refresh');
            }
        
            $page_data['exam_id']       =   trim($this->security->xss_clean(trim($exam_id)));
            $page_data['class_id']      =   trim($this->security->xss_clean(trim($class_id)));
            // $page_data['student_id']    =   $student_id;
            $page_data['subject_id']   =    trim($this->security->xss_clean(trim($subject_id)));
            $page_data['running_session']=  $running_session;
            $page_data['teachers_identity'] = $teachers_identity;
            $page_data['page_name']     =   'student_marksheet_subject';
            $page_data['page_title']    = get_phrase('Student Marks');
            $this->load->view('backend/index', $page_data);
        }//active session
        else
        {
            redirect(base_url(), 'refresh');
        }
    }


    function promote_student($param1 = null, $param2 = null, $param3 = null)
    {

        if($this->session->userdata('login_user_id'))
        {
             if ($param1 == 'update')
             {

                    $promoted_session = $this->get_promoted_session();

                    if($promoted_session !='0' || $promoted_session !='')
                    {
                        $current_academic_session = $this->get_running_session();

                        $student_promote_id = $this->input->post('student_promote_id');

                        $exam_id = $this->input->post('exam_id');

                        $class_id = $this->input->post('class_id');

                        $page_data['class_id'] = $class_id;

                        $class_id = $this->input->post('class_id');

                       $is_promoted = $this->crud_model->promote_student($student_promote_id,$promoted_session,$current_academic_session,$class_id);

                       if($is_promoted == 1)
                       {
                         $this->session->set_flashdata('flash_message', get_phrase('Student promoted successfully.'));
                       }
                       else
                       {
                         $this->session->set_flashdata('flash_message', get_phrase('Student could not promoted successfully.'));
                       }
                    
                    }
                    else
                    {
                        $this->session->set_flashdata('flash_message', get_phrase('Student could not promoted successfully.Promoted Session is not set yet!'));
                    }


                    redirect(base_url() . 'teacher/tabulation_sheet', 'refresh');
            }
        }//login active
        else
        {
            redirect(base_url(), 'refresh');
        }

    }

    function promote_student_all()
    {
        if (!$this->input->is_ajax_request()) {
           exit('No direct script access allowed');
        }
        if($this->session->userdata('login_user_id'))
        {
            $student_ids = $this->input->post("student_ids");
            $promoted_class = $this->input->post("promoted_class");

            $promoted_session = $this->get_promoted_session();

            if($promoted_session !='0' || $promoted_session !='')
            {
                $current_academic_session = $this->get_running_session();
                $promoted_counter=1;
                
                foreach($student_ids as $student_promote_id)
                {
                     $is_promoted = $this->crud_model->promote_student($student_promote_id,$promoted_session,$current_academic_session,$promoted_class);

                       if($is_promoted == 1)
                       {
                         $promoted_counter++;
                       }
                }

                $resp = array(
                    'resp_code'=>'success',
                    'resp_message'=>($promoted_counter-1)." students promoted successfully."
                );
            }
            else
            {
                $resp = array(
                    'resp_code'=>'error',
                    'resp_message'=>"Promoted Session is not set yet!"
                );
            }

            echo json_encode($resp);
        }
        else
        {
            redirect(base_url(), 'refresh');
        }
    }
    /***********  The function that manages school marks ends here ***********************/    






    /********** the functino createan online exam for students ********************/

    function manage_online_exam($param1 = "", $param2 = "")
    {

        if ($this->session->userdata('teacher_login') != 1)

            redirect(base_url(), 'refresh');



        $running_year = get_settings('session');



        if ($param1 == '') {

            $match = array('status !=' => 'expired', 'running_year' => $running_year);

            $page_data['status'] = 'active';

            $this->db->order_by("exam_date", "dsc");

            $page_data['online_exams'] = $this->db->where($match)->get('online_exam')->result_array();
        }



        if ($param1 == 'expired') {    // if parameter is equal to expired do the below information

            $match = array('status' => 'expired', 'running_year' => $running_year);

            $page_data['status'] = 'expired';

            $this->db->order_by("exam_date", "dsc");

            $page_data['online_exams'] = $this->db->where($match)->get('online_exam')->result_array();
        }



        if ($param1 == 'create') {    // if parameter is equal to create do the below information

            if (trim($this->security->xss_clean(trim($this->input->post('class_id')))) > 0 && trim($this->security->xss_clean(trim($this->input->post('section_id')))) > 0 && trim($this->security->xss_clean(trim($this->input->post('subject_id')))) > 0) {

                $this->crud_model->create_online_exam();

                $this->session->set_flashdata('flash_message', get_phrase('data_added_successfully'));

                redirect(site_url('teacher/manage_online_exam'), 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('make_sure_to_select_valid_class_') . ',' . get_phrase('_section_and_subject'));

                redirect(site_url('teacher/manage_online_exam'), 'refresh');
            }
        }

        if ($param1 == 'edit') {                // if parameter is equal to edit then do the below information

            if (trim($this->security->xss_clean(trim($this->input->post('class_id')))) > 0 && trim($this->security->xss_clean(trim($this->input->post('section_id')))) > 0 && trim($this->security->xss_clean(trim($this->input->post('subject_id')))) > 0) {

                $this->crud_model->update_online_exam();

                $this->session->set_flashdata('flash_message', get_phrase('data_updated_successfully'));

                redirect(site_url('teacher/manage_online_exam'), 'refresh');
            } else {

                $this->session->set_flashdata('error_message', get_phrase('make_sure_to_select_valid_class_') . ',' . get_phrase('_section_and_subject'));

                redirect(site_url('teacher/manage_online_exam'), 'refresh');
            }
        }

        if ($param1 == 'delete') {    // if parameter is equal to delete do the below information

            $this->db->where('online_exam_id', trim($this->security->xss_clean(trim($param2))));

            $this->db->delete('online_exam');

            $this->session->set_flashdata('flash_message', get_phrase('data_deleted'));

            redirect(site_url('teacher/manage_online_exam'), 'refresh');
        }

        $page_data['page_name'] = 'manage_online_exam';

        $page_data['page_title'] = get_phrase('manage_online_exam');

        $this->load->view('backend/index', $page_data);
    }



    /********** the functino create an online_exam_questions_print_view ********************/

    function online_exam_questions_print_view($online_exam_id, $answers)
    {

        if ($this->session->userdata('teacher_login') != 1)

            redirect(site_url('login'), 'refresh');



        $page_data['online_exam_id'] = trim($this->security->xss_clean(trim($online_exam_id)));

        $page_data['answers'] = trim($this->security->xss_clean(trim($answers)));

        $page_data['page_title'] = get_phrase('questions_print');

        $this->load->view('backend/teacher/online_exam_questions_print_view', $page_data);
    }

    /********** the functino create an online_exam_questions_print_view ********************/



    /********** the functino create an create_online_exam ********************/

    function create_online_exam()
    {

        $page_data['page_name'] = 'add_online_exam';

        $page_data['page_title'] = get_phrase('add_an_online_exam');

        $this->load->view('backend/index', $page_data);
    }

    /********** the functino create an /create_online_exam ********************/



    /********** the functino create an update_online_exam ********************/

    function update_online_exam($param1 = "")
    {

        $page_data['online_exam_id'] = trim($this->security->xss_clean(trim($param1)));

        $page_data['page_name'] = 'edit_online_exam';

        $page_data['page_title'] = get_phrase('update_online_exam');

        $this->load->view('backend/index', $page_data);
    }

    /********** the functino create an /update_online_exam ********************/



    /********** the functino create an manage_online_exam_status ********************/

    function manage_online_exam_status($online_exam_id = "", $status = "")
    {

        $this->crud_model->manage_online_exam_status(trim($this->security->xss_clean(trim($online_exam_id))),trim($this->security->xss_clean(trim($status))));

        redirect(site_url('teacher/manage_online_exam'), 'refresh');
    }

    /********** the functino create an /manage_online_exam_status ********************/



    function load_question_type($type, $online_exam_id)
    {

        $page_data['question_type'] = trim($this->security->xss_clean(trim($type)));

        $page_data['online_exam_id'] = trim($this->security->xss_clean(trim($online_exam_id)));

        $this->load->view('backend/teacher/online_exam_add_' . $type, $page_data);
    }



    function manage_online_exam_question($online_exam_id = "", $task = "", $type = "")
    {

        if ($this->session->userdata('teacher_login') != 1)

            redirect(site_url('login'), 'refresh');



        if ($task == 'add') {

            if ($type == 'multiple_choice') {

                $this->crud_model->add_multiple_choice_question_to_online_exam(trim($this->security->xss_clean(trim($online_exam_id))));
            } elseif ($type == 'true_false') {

                $this->crud_model->add_true_false_question_to_online_exam(trim($this->security->xss_clean(trim($online_exam_id))));
            } elseif ($type == 'fill_in_the_blanks') {

                $this->crud_model->add_fill_in_the_blanks_question_to_online_exam(trim($this->security->xss_clean(trim($online_exam_id))));
            }

            redirect(site_url('teacher/manage_online_exam_question/' . $online_exam_id), 'refresh');
        }



        $online_exam_id = trim($this->security->xss_clean(trim($online_exam_id)));
        
        $equivalent_exam_details = $this->crud_model->get_equivalent_exam_class($online_exam_id);

        $page_data['online_exam_id'] = $online_exam_id;
        $page_data['equivalent_exam_class'] = $equivalent_exam_details;

        $page_data['page_name'] = 'manage_online_exam_question';

        $page_data['page_title'] = $this->db->get_where('online_exam', array('online_exam_id' => $online_exam_id))->row()->title;

        $this->load->view('backend/index', $page_data);
    }



    /********** function to update online exam for students ********************/

    function update_online_exam_question($question_id = "", $task = "", $online_exam_id = "")
    {

        if ($this->session->userdata('teacher_login') != 1)

            redirect(site_url('login'), 'refresh');

        $question_id = trim($this->security->xss_clean(trim($question_id)));

        $online_exam_id = $this->db->get_where('question_bank', array('question_bank_id' => $question_id))->row()->online_exam_id;

        $type = $this->db->get_where('question_bank', array('question_bank_id' => $question_id))->row()->type;

        if ($task == "update") {

            if ($type == 'multiple_choice') {

                $this->crud_model->update_multiple_choice_question($question_id);
            } elseif ($type == 'true_false') {

                $this->crud_model->update_true_false_question($question_id);
            } elseif ($type == 'fill_in_the_blanks') {

                $this->crud_model->update_fill_in_the_blanks_question($question_id);
            }

            redirect(site_url('teacher/manage_online_exam_question/' . $online_exam_id), 'refresh');
        }

        $page_data['question_id'] = $question_id;

        $page_data['page_name'] = 'update_online_exam_question';

        $page_data['page_title'] = get_phrase('update_question');

        $this->load->view('backend/index', $page_data);
    }



    function delete_question_from_online_exam($question_id)
    {

        $question_id = trim($this->security->xss_clean(trim($question_id)));
        
        $online_exam_id = $this->db->get_where('question_bank', array('question_bank_id' => $question_id))->row()->online_exam_id;

        $this->crud_model->delete_question_from_online_exam($question_id);

        $this->session->set_flashdata('flash_message', get_phrase('question_deleted'));

        redirect(site_url('teacher/manage_online_exam_question/' . $online_exam_id), 'refresh');
    }



    function manage_multiple_choices_options()
    {

        $page_data['number_of_options'] = trim($this->security->xss_clean(trim($this->input->post('number_of_options'))));

        $this->load->view('backend/teacher/manage_multiple_choices_options', $page_data);
    }



    function view_online_exam_result($online_exam_id)
    {

        $page_data['page_name'] = 'view_online_exam_results';

        $page_data['page_title'] = get_phrase('result');

        $page_data['online_exam_id'] = trim($this->security->xss_clean(trim($online_exam_id)));

        $this->load->view('backend/index', $page_data);
    }


    // Load Student by Class ID & Running Session

    function load_students_byclass()
    {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
         }
         if($this->session->userdata('login_user_id'))
         {
             $class_id = $this->input->post("class_id");
             $running_session = $this->get_running_session();;
             
            
             $get_students = $this->crud_model->getStudentsByClassIDnSession($class_id,$running_session);
 
             if(count($get_students) > 0)
             {
                $select_id = "student_id_" . $class_id; // Dynamic ID for the select element
                $selected_student_id = $this->input->post("student_id");

                $class_name_mysql = $this->crud_model->get_data_mysql('name','class',$whr="class_id='".$class_id."'",$order='name asc',$qry_typ='1');
                if(is_object($class_name_mysql))
                {
                    $class_name = $class_name_mysql->name;
                }
                else
                {
                    $class_name = "";
                }
                // Start building the select dropdown
                $select_html = '<select name="temp" id="' . $select_id . '" class="form-control">';
                $select_html .= '<option value="">Student of: ' . $class_name . '</option>';
            
                // Loop through the students and add options
                foreach ($get_students as $student) {

                    $is_student_selected = ($student->student_id == $selected_student_id) ? 'selected' : ''; 
                    $select_html .= '<option value="' . $student->student_id . '"'.$is_student_selected.'>' . $student->name . '</option>';
                }
            
                // Close the select element
                $select_html .= '</select>';
 
                 $resp = array(
                     'resp_code'=>'success',
                     'resp_message'=>'Success',
                     'html_str'=>$select_html
                 );
             }
             else
             {
                 $resp = array(
                     'resp_code'=>'error',
                     'resp_message'=>"No students found for the selected class and session for the logged in Teacher !"
                 );
             }
 
             echo json_encode($resp);
         }
    }

    // Load Student by Class ID & Running Session

    function load_subjects_byclass()
    {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
         }
         if($this->session->userdata('login_user_id'))
         {
             $class_id = $this->input->post("class_id");
             $running_session = $this->get_running_session();
             $teachers_identity = $this->session->userdata('login_user_id');
             
            // echo $class_id."_".$running_session."_".$teachers_identity;
             
             $get_subjects = $this->crud_model->getSubjectsByClassIDnTeacherIDnSession($class_id,$teachers_identity,$running_session);
            //  echo "<pre>";
            //  print_r($get_subjects);
            //  exit;
 
             if(count($get_subjects) > 0)
             {
                $select_id = "subject_id_" . $class_id;
                $selected_subject_id = $this->input->post("selected_subject_id");

                $class_name_mysql = $this->crud_model->get_data_mysql('name','class',$whr="class_id='".$class_id."'",$order='name asc',$qry_typ='1');
                if(is_object($class_name_mysql))
                {
                    $class_name = $class_name_mysql->name;
                }
                else
                {
                    $class_name = "";
                }
                // Start building the select dropdown
                $select_html = '<select name="" id="' . $select_id . '" class="form-control">';
                $select_html .= '<option value="">Subject of: ' . $class_name . '</option>';
            
                // Loop through the subjects and add options
                foreach ($get_subjects as $subjects) {
                    $is_subject_selected = ($subjects->subject_id == $selected_subject_id) ? 'selected' : ''; 
                    $select_html .= '<option value="' . $subjects->subject_id . '"'.$is_subject_selected.'>' . $subjects->name . '</option>';
                }
            
                // Close the select element
                $select_html .= '</select>';
 
                 $resp = array(
                     'resp_code'=>'success',
                     'resp_message'=>'Success',
                     'html_str'=>$select_html
                 );
             }
             else
             {
                 $resp = array(
                     'resp_code'=>'error',
                     'resp_message'=>"No Subjects found for the selected class and session for the logged in Teacher !"
                 );
             }
 
             echo json_encode($resp);
         }
    }

    // add comment & delete comment

    function addcomment($param1 = null, $param2 = null, $param3 = null)
    {

        if ($param1 == 'insert') {

            $class_id = $this->input->post('class_id');

            $exam_id = $this->input->post('exam_id');

            $page_data['student_id'] = $this->input->post('student_id');

            $page_data['comment'] = $this->input->post('comment');

            $this->db->insert('teachercomment', $page_data);

            $this->session->set_flashdata('flash_message', get_phrase('Comment added successfully'));

            redirect(base_url() . 'teacher/print_mass_report_card/' . $class_id . '/' . $exam_id, 'refresh');

            // echo json_encode($page_data);

        }



        if ($param1 == 'delete') {

            
            $class_id = $this->input->get('class_id');

            $exam_id = $this->input->get('exam_id');

            $this->db->where('id', $param2);

            $this->db->delete('teachercomment');

            $this->session->set_flashdata('flash_message', get_phrase('Comment deleted successfully'));

            redirect(base_url() . 'teacher/print_mass_report_card/' . $class_id . '/' . $exam_id, 'refresh');
        }
    }



}