<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Report extends CI_Controller {

    function __construct() {
        parent::__construct();
        		$this->load->database();
        		$this->load->library('session');					//Load library for session
                $this->load->helper('security');
    }


    function studentPaymentReport ($param1 = null, $param2 = null, $param3 = null){

    $page_data['page_name']     = 'studentPaymentReport';
    $page_data['page_title']    = get_phrase('Payment Report');
    $this->load->view('backend/index', $page_data);

    }


    function classAttendanceReport($class_id = NULL, $section_id = NULL, $month = NULL, $year = NULL) {
        
        $active_sms_gateway = $this->db->get_where('sms_settings', array('type' => 'active_sms_gateway'))->row()->info;
        
        
        if ($_POST) {
            redirect(base_url() . 'admin/classAttendanceReport/' . trim($this->security->xss_clean(trim($class_id))) . '/' . trim($this->security->xss_clean(trim($section_id))) . '/' . trim($this->security->xss_clean(trim($month))) . '/' . trim($this->security->xss_clean(trim($year))), 'refresh');
        }
        
        $classes = $this->db->get('class')->result_array();
        foreach ($classes as $key => $class) {
            if (isset($class_id) && trim($this->security->xss_clean(trim($class_id))) == $class['class_id'])
                $class_name = $class['name'];
            }
                    
        $sections = $this->db->get('section')->result_array();
            foreach ($sections as $key => $section) {
                if (isset($section_id) && trim($this->security->xss_clean(trim($section_id))) == $section['section_id'])
                    $section_name = $section['name'];
        }
        
        $page_data['month'] = trim($this->security->xss_clean(trim($month)));
        $page_data['year'] = trim($this->security->xss_clean(trim($year)));
        $page_data['class_id'] = trim($this->security->xss_clean(trim($class_id)));
        $page_data['section_id'] = trim($this->security->xss_clean(trim($section_id)));
        $page_data['page_name'] = 'attendance_report';
        $page_data['page_title'] = "Attendance Report:" . $class_name . " : Section " . $section_name;
        $this->load->view('backend/index', $page_data);
    }




    /***********  The function below manages school marks ***********************/
    function examMarkReport ($exam_id = null, $class_id = null, $student_id = null){

        if($this->input->post('operation') == 'selection'){

            $page_data['exam_id']       =  trim($this->security->xss_clean(trim($this->input->post('exam_id')))); 
            $page_data['class_id']      =  trim($this->security->xss_clean(trim($this->input->post('class_id'))));
            $page_data['student_id']    =  trim($this->security->xss_clean(trim($this->input->post('student_id'))));

            if($page_data['exam_id'] > 0 && $page_data['class_id'] > 0 && $page_data['student_id'] > 0){

                redirect(base_url(). 'report/examMarkReport/'. $page_data['exam_id'] .'/' . $page_data['class_id'] . '/' . $page_data['student_id'], 'refresh');
            }
            else{
                $this->session->set_flashdata('error_message', get_phrase('Pleasen select something'));
                redirect(base_url(). 'report/examMarkReport', 'refresh');
            }
        }
    $page_data['exam_id']       =   trim($this->security->xss_clean(trim($exam_id)));
    $page_data['class_id']      =   trim($this->security->xss_clean(trim($class_id)));
    $page_data['student_id']    =   trim($this->security->xss_clean(trim($section_id)));
    $page_data['subject_id']   =    trim($this->security->xss_clean(trim($subject_id)));
    $page_data['page_name']     =   'examMarkReport';
    $page_data['page_title']    = get_phrase('Student Marks');
    $this->load->view('backend/index', $page_data);
}
/***********  The function that manages school marks ends here ***********************/


	
	
	

	
}
